/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.eicml;

import ch.systemsx.cisd.yeastx.db.AbstractDatasetLoader;
import ch.systemsx.cisd.yeastx.db.generic.DMDataSetDTO;
import ch.systemsx.cisd.yeastx.eicml.ChromatogramDTO;
import ch.systemsx.cisd.yeastx.eicml.EICMLParser;
import ch.systemsx.cisd.yeastx.eicml.EICMSRunDTO;
import ch.systemsx.cisd.yeastx.eicml.IEICMSRunDAO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class EICML2Database
extends AbstractDatasetLoader<IEICMSRunDAO> {
    private static final int CHROMATOGRAM_BATCH_SIZE = 100;

    private static void addChromatograms(IEICMSRunDAO dao, long eicMLId, List<ChromatogramDTO> chromatograms, int threshold) {
        if (chromatograms.size() >= threshold) {
            dao.addChromatograms(eicMLId, chromatograms);
            chromatograms.clear();
        }
    }

    public EICML2Database(DataSource dataSource) {
        super(dataSource, IEICMSRunDAO.class);
    }

    @Override
    public void upload(File eicMLFile, final DMDataSetDTO dataSet) {
        final long[] eicMLId = new long[1];
        final ArrayList<ChromatogramDTO> chromatograms = new ArrayList<ChromatogramDTO>(100);
        try {
            this.createDataSet(dataSet);
            new EICMLParser(eicMLFile.getPath(), new EICMLParser.IMSRunObserver(){

                @Override
                public void observe(EICMSRunDTO run) {
                    EICML2Database.addChromatograms((IEICMSRunDAO)EICML2Database.this.getDao(), eicMLId[0], chromatograms, 1);
                    run.setExperimentId(dataSet.getExperimentId());
                    run.setSampleId(dataSet.getSampleId());
                    run.setDataSetId(dataSet.getId());
                    eicMLId[0] = ((IEICMSRunDAO)EICML2Database.this.getDao()).addMSRun(run);
                }
            }, new EICMLParser.IChromatogramObserver(){

                @Override
                public void observe(ChromatogramDTO chromatogram) {
                    chromatograms.add(chromatogram);
                    EICML2Database.addChromatograms((IEICMSRunDAO)EICML2Database.this.getDao(), eicMLId[0], chromatograms, 100);
                }
            });
            EICML2Database.addChromatograms((IEICMSRunDAO)this.getDao(), eicMLId[0], chromatograms, 1);
        }
        catch (Throwable th) {
            this.rollbackAndRethrow(th);
        }
    }
}

