/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.parser.TabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.yeastx.etl.DataSetMappingInformation;
import ch.systemsx.cisd.yeastx.etl.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

class DataSetMappingInformationParser {
    DataSetMappingInformationParser() {
    }

    public static List<DataSetMappingInformation> tryParse(File mappingFile, LogUtils log) {
        TabFileLoader tabFileLoader = new TabFileLoader((IParserObjectFactoryFactory)new IParserObjectFactoryFactory<DataSetMappingInformation>(){

            public IParserObjectFactory<DataSetMappingInformation> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new NewPropertyParserObjectFactory(propertyMapper);
            }
        });
        try {
            Map defauts = Collections.emptyMap();
            return tabFileLoader.load(mappingFile, defauts);
        }
        catch (IllegalArgumentException e) {
            DataSetMappingInformationParser.logParsingError(log, e, mappingFile);
            return null;
        }
        catch (Exception e) {
            DataSetMappingInformationParser.logParsingError(log, e, mappingFile);
            return null;
        }
    }

    private static void logParsingError(LogUtils log, Exception e, File mappingFile) {
        Throwable cause = e.getCause();
        String causeMsg = "";
        if (cause != null) {
            causeMsg = "\nThe exception was caused by: " + cause.getMessage();
        }
        log.mappingFileError(mappingFile, "the mapping file '%s' has incorrect format. The problem is:\n%s%s", mappingFile.getPath(), e.getMessage(), causeMsg);
    }

    private static final class NewPropertyParserObjectFactory
    extends AbstractParserObjectFactory<DataSetMappingInformation> {
        private NewPropertyParserObjectFactory(IPropertyMapper propertyMapper) {
            super(DataSetMappingInformation.class, propertyMapper);
        }

        private final void setProperties(DataSetMappingInformation dataset, String[] lineTokens) {
            ArrayList<NewProperty> properties = new ArrayList<NewProperty>();
            for (String unmatchedProperty : this.getUnmatchedProperties()) {
                String propertyDefault;
                IPropertyModel propertyModel = this.tryGetPropertyModel(unmatchedProperty);
                String propertyValue = this.getPropertyValue(lineTokens, propertyModel, propertyDefault = this.tryGetPropertyDefault(unmatchedProperty));
                if (StringUtils.isEmpty((String)propertyValue)) continue;
                NewProperty property = new NewProperty();
                property.setPropertyCode(propertyModel.getCode());
                property.setValue(propertyValue);
                properties.add(property);
            }
            dataset.setProperties(properties);
        }

        protected final boolean ignoreUnmatchedProperties() {
            return true;
        }

        public final DataSetMappingInformation createObject(String[] lineTokens) throws ParserException {
            DataSetMappingInformation dataset = (DataSetMappingInformation)super.createObject(lineTokens);
            this.setProperties(dataset, lineTokens);
            return dataset;
        }
    }
}

