/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessor;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.utils.PreprocessingExecutor;
import ch.systemsx.cisd.yeastx.etl.ML2DatabaseUploader;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public class QuantMLStorageProcessor
extends AbstractDelegatingStorageProcessor {
    private final ML2DatabaseUploader databaseUploader;
    private final String mlFileExtension;
    private final PreprocessingExecutor writeAccessSetter;

    public QuantMLStorageProcessor(Properties properties) {
        super(properties);
        this.databaseUploader = new ML2DatabaseUploader(properties);
        this.mlFileExtension = "quantML";
        this.writeAccessSetter = PreprocessingExecutor.create((Properties)properties);
    }

    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        return new QuantMLStorageProcessorTransaction(parameters, super.createTransaction(parameters), this);
    }

    public static File findFile(File incomingItem, String fileExtension) {
        if (incomingItem.isFile() && FilenameUtils.isExtension((String)incomingItem.getName(), (String)fileExtension)) {
            return incomingItem;
        }
        List files = FileOperations.getInstance().listFiles(incomingItem, new String[]{fileExtension}, false);
        if (files.size() != 1) {
            throw UserFailureException.fromTemplate((String)"There should be exactly one file with '%s' extension in '%s' directory, but %d have been found.", (Object[])new Object[]{fileExtension, incomingItem.getPath(), files.size()});
        }
        return (File)files.get(0);
    }

    private void acquireWriteAccess(File incomingDataSetDirectory) {
        String incomingName = incomingDataSetDirectory.getName();
        boolean ok = this.writeAccessSetter.execute(incomingName);
        if (!ok) {
            throw UserFailureException.fromTemplate((String)("Cannot get the write access to the dataset: " + incomingName), (Object[])new Object[0]);
        }
    }

    private void ensureUploadableFileExists(File incomingDataSetDirectory) {
        QuantMLStorageProcessor.findFile(incomingDataSetDirectory, this.mlFileExtension);
    }

    private static class QuantMLStorageProcessorTransaction
    extends AbstractDelegatingStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private transient QuantMLStorageProcessor processor;

        public QuantMLStorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, IStorageProcessorTransactional.IStorageProcessorTransaction nestedTransaction, QuantMLStorageProcessor quantMLStorageProcessor) {
            super(parameters, nestedTransaction);
            this.processor = quantMLStorageProcessor;
        }

        protected File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            this.processor.ensureUploadableFileExists(this.incomingDataSetDirectory);
            this.processor.acquireWriteAccess(this.incomingDataSetDirectory);
            this.nestedTransaction.storeData(typeExtractor, mailClient, this.incomingDataSetDirectory);
            File originalData = this.nestedTransaction.tryGetProprietaryData();
            File quantML = QuantMLStorageProcessor.findFile(originalData, this.processor.mlFileExtension);
            this.processor.databaseUploader.upload(quantML, this.dataSetInformation);
            return this.nestedTransaction.getStoredDataDirectory();
        }

        protected void executeCommit() {
            this.nestedTransaction.commit();
            this.processor.databaseUploader.commit();
        }

        protected IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable ex) {
            try {
                this.nestedTransaction.rollback(ex);
            }
            finally {
                if (this.processor != null && this.processor.databaseUploader != null) {
                    this.processor.databaseUploader.rollback();
                }
            }
            return IStorageProcessorTransactional.UnstoreDataAction.LEAVE_UNTOUCHED;
        }
    }
}

