/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Friend;
import ch.systemsx.cisd.common.collection.CollectionStyle;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="events")
@Friend(toClasses={DataPE.class})
public class EventPE
extends HibernateAbstractRegistrationHolder
implements IIdHolder,
Serializable {
    public static final String IDENTIFIER_SEPARATOR = ", ";
    private static final long serialVersionUID = 35L;
    private transient Long id;
    private EventType eventType;
    private EntityType entityType;
    private List<String> identifiers;
    private String description;
    private String reason;

    public final void setId(Long id) {
        this.id = id;
    }

    @Override
    @Id
    @SequenceGenerator(name="EVENT_ID_SEQ", sequenceName="EVENT_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EVENT_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @NotNull(message="Event Type can not be null.")
    @Column(name="event_type")
    @Enumerated(value=EnumType.STRING)
    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @NotNull(message="Entity Type can not be null.")
    @Column(name="entity_type")
    @Enumerated(value=EnumType.STRING)
    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    @NotNull(message="Identifier can not be null.")
    @Column(name="identifiers")
    private String getIdentifiersInternal() {
        return CollectionUtils.abbreviate(this.identifiers, -1, CollectionStyle.NO_BOUNDARY);
    }

    private void setIdentifiersInternal(String identifier) {
        this.identifiers = Arrays.asList(identifier.split(IDENTIFIER_SEPARATOR));
    }

    @Transient
    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<String> identifiers) {
        this.identifiers = identifiers;
    }

    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)true);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)true);
    }

    public static enum EntityType {
        ATTACHMENT,
        DATASET,
        EXPERIMENT,
        SPACE,
        MATERIAL,
        PROJECT,
        PROPERTY_TYPE,
        SAMPLE,
        VOCABULARY,
        AUTHORIZATION_GROUP,
        METAPROJECT;

    }
}

