/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property.structured;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.EntityLinkElementKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IElement;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IElementFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IStructuredPropertyConverter;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.EntityLinkElement;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class JsonStructuredPropertyConverter
implements IStructuredPropertyConverter {
    private static final String ROOT_NAME = "root";
    private static final String ID_KEY = "id";
    private static final String DATA_KEY = "data";
    private static final String ATTR_KEY = "attr";
    private static final String CHILDREN_KEY = "child";
    private static final TopLevelPrettyPrinter topLevelPrettyPrinter = new TopLevelPrettyPrinter();
    private final IElementFactory factory;

    public JsonStructuredPropertyConverter(IElementFactory factory) {
        this.factory = factory;
    }

    public boolean canHandle(IManagedProperty property) {
        return this.canHandle(property.getValue());
    }

    public boolean canHandle(String string) {
        return string.startsWith("[");
    }

    @Override
    public List<IElement> convertToElements(IManagedProperty property) {
        return this.convertStringToElements(property.getValue());
    }

    @Override
    public List<IElement> convertStringToElements(String propertyValue) {
        JsonNode rootNode;
        if (ManagedProperty.isSpecialValue(propertyValue) || StringUtils.isBlank((String)propertyValue)) {
            return Collections.emptyList();
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            rootNode = (JsonNode)mapper.readValue(propertyValue, JsonNode.class);
        }
        catch (Exception ex) {
            throw new UserFailureException("Cannot parse property '" + propertyValue + "'.", ex);
        }
        IElement root = this.transformFromDOM(rootNode);
        return root.getChildren();
    }

    private IElement transformFromDOM(JsonNode node) {
        if (node.isObject()) {
            return this.transformFromDOM((ObjectNode)node);
        }
        if (node.isArray()) {
            IElement result = this.factory.createElement(ROOT_NAME);
            for (JsonNode child : node) {
                result.addChildren(this.transformFromDOM(child));
            }
            return result;
        }
        throw new IllegalArgumentException("Illegal JSNO node: " + node.getClass());
    }

    private IElement transformFromDOM(ObjectNode node) {
        IElement result = this.createElementForNode(node);
        this.transformAttributesFromDOM((JsonNode)node, result);
        this.transformDataFromDOM(node, result);
        this.transformChildrenFromDOM(node, result);
        return result;
    }

    private void transformAttributesFromDOM(JsonNode node, IElement result) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Map.Entry<String, JsonNode> entry : new EntryIt(node.path(ATTR_KEY).fields())) {
            attributes.put(entry.getKey(), entry.getValue().textValue());
        }
        result.setAttributes(attributes);
    }

    private void transformDataFromDOM(ObjectNode node, IElement result) {
        JsonNode dataNode = node.path(DATA_KEY);
        if (dataNode.isValueNode()) {
            result.setData(dataNode.asText());
        }
    }

    private void transformChildrenFromDOM(ObjectNode node, IElement result) {
        JsonNode childrenNode = node.path(CHILDREN_KEY);
        if (childrenNode.isArray()) {
            for (JsonNode child : childrenNode) {
                result.addChildren(this.transformFromDOM(child));
            }
        }
    }

    private IElement createElementForNode(ObjectNode node) {
        String nodeName = node.get(ID_KEY).textValue();
        EntityLinkElementKind linkKind = EntityLinkElementKind.tryGetForElementName(nodeName);
        if (linkKind != null) {
            String permId = this.getAttrValueOrFail(nodeName, node, "permId");
            return new EntityLinkElement(linkKind, permId);
        }
        return this.factory.createElement(nodeName);
    }

    private String getAttrValueOrFail(String nodeName, ObjectNode node, String attrName) {
        String attr = node.path(ATTR_KEY).path(attrName).asText();
        if (StringUtils.isBlank((String)attr)) {
            String error = String.format("Attribute [%s] expected in nodes with name %s", attrName, nodeName);
            throw new IllegalArgumentException(error);
        }
        return attr;
    }

    @Override
    public String convertToString(List<IElement> elements) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = this.transformToDOM(mapper, elements);
        try {
            return mapper.writer((PrettyPrinter)topLevelPrettyPrinter).writeValueAsString((Object)rootNode);
        }
        catch (Exception ex) {
            throw new UserFailureException("Cannot generate DOM.", ex);
        }
    }

    private JsonNode transformToDOM(ObjectMapper mapper, List<IElement> elements) {
        ArrayNode result = mapper.createArrayNode();
        for (IElement child : elements) {
            JsonNode childNode = this.transformToDOM(mapper, child);
            result.add(childNode);
        }
        return result;
    }

    private JsonNode transformToDOM(ObjectMapper mapper, IElement element) {
        ObjectNode result = mapper.createObjectNode();
        result.put(ID_KEY, element.getName());
        this.transformAttributesToDOM(mapper, element, result);
        if (element.getData() != null) {
            result.put(DATA_KEY, element.getData());
        }
        if (!element.getChildren().isEmpty()) {
            result.put(CHILDREN_KEY, this.transformToDOM(mapper, element.getChildren()));
        }
        return result;
    }

    private void transformAttributesToDOM(ObjectMapper mapper, IElement element, ObjectNode result) {
        if (element.getAttributes().isEmpty()) {
            return;
        }
        ObjectNode attributes = mapper.createObjectNode();
        for (Map.Entry<String, String> entry : element.getAttributes().entrySet()) {
            attributes.put(entry.getKey(), entry.getValue());
        }
        result.put(ATTR_KEY, (JsonNode)attributes);
    }

    private static class EntryIt
    implements Iterable<Map.Entry<String, JsonNode>> {
        private final Iterator<Map.Entry<String, JsonNode>> it;

        EntryIt(Iterator<Map.Entry<String, JsonNode>> it) {
            this.it = it;
        }

        @Override
        public Iterator<Map.Entry<String, JsonNode>> iterator() {
            return this.it;
        }
    }

    private static class TopLevelPrettyPrinter
    extends MinimalPrettyPrinter {
        private int level = 0;

        private TopLevelPrettyPrinter() {
        }

        public void writeStartArray(JsonGenerator jg) throws IOException, JsonGenerationException {
            if (this.level++ == 0) {
                jg.writeRaw("[\n  ");
            } else {
                jg.writeRaw('[');
            }
        }

        public void writeArrayValueSeparator(JsonGenerator jg) throws IOException, JsonGenerationException {
            if (this.level == 1) {
                jg.writeRaw(",\n  ");
            } else {
                jg.writeRaw(',');
            }
        }

        public void writeEndArray(JsonGenerator jg, int nrOfValues) throws IOException, JsonGenerationException {
            if (--this.level == 0) {
                jg.writeRaw("\n]");
            } else {
                jg.writeRaw(']');
            }
        }
    }
}

