/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.converter.Converter;
import java.io.File;
import org.apache.commons.io.FilenameUtils;

public abstract class AbstractFileBasedConverter<T>
implements Converter<T> {
    private final File rootDir;

    public AbstractFileBasedConverter(File rootDir) {
        this.rootDir = rootDir;
    }

    public static final boolean isIncludeFile(String valueOrNull) {
        if (valueOrNull == null) {
            return false;
        }
        String trimmed = valueOrNull.trim();
        return trimmed.startsWith(">") && trimmed.length() > 1;
    }

    protected abstract T convert(File var1);

    @Override
    public final T convert(String valueOrNull) {
        if (AbstractFileBasedConverter.isIncludeFile(valueOrNull)) {
            String fileName = valueOrNull.substring(1).trim();
            int prefixLength = FilenameUtils.getPrefixLength(fileName);
            return this.convert(prefixLength == 0 ? new File(this.rootDir, fileName) : new File(fileName));
        }
        return null;
    }
}

