/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.servlet;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.common.shared.basic.exception.IOptionalStackTraceLoggingException;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public abstract class GWTRPCServiceExporter
extends RemoteServiceServlet
implements InitializingBean,
ServletConfigAware,
DisposableBean,
BeanNameAware,
Controller {
    private static final String SESSION_EXP_MSG = "Session expired. Please login again.";
    private static final long serialVersionUID = 1L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, GWTRPCServiceExporter.class);
    private ServletConfig servletConfig;
    private String beanName;
    private Map<Method, Method> methodCache = new HashMap<Method, Method>();

    private final String invokeMethodOnService(Method targetMethod, Object[] targetParameters, RPCRequest rpcRequest) throws SerializationException {
        Object result = ClassUtils.invokeMethod(targetMethod, this.getService(), targetParameters);
        return RPC.encodeResponseForSuccess((Method)rpcRequest.getMethod(), (Object)result, (SerializationPolicy)rpcRequest.getSerializationPolicy());
    }

    private final synchronized Method getMethodToInvoke(Method decodedMethod) {
        Method method = this.methodCache.get(decodedMethod);
        if (method != null) {
            return method;
        }
        try {
            method = this.getService().getClass().getMethod(decodedMethod.getName(), decodedMethod.getParameterTypes());
            this.methodCache.put(decodedMethod, method);
            return method;
        }
        catch (NoSuchMethodException ex) {
            throw new CheckedExceptionTunnel(ex);
        }
    }

    private static final void logException(Exception e) {
        operationLog.error(String.format("An '%s' was thrown while processing this call.", e.getClass().getSimpleName()), e);
    }

    private final String handleIncompatibleRemoteServiceException(IncompatibleRemoteServiceException e) throws SerializationException {
        GWTRPCServiceExporter.logException((Exception)e);
        return RPC.encodeResponseForFailure(null, (Throwable)e);
    }

    private final String handleInvocationException(RuntimeException e, Method targetMethod, RPCRequest rpcRequest) throws Exception {
        Exception cause = CheckedExceptionTunnel.unwrapIfNecessary(e);
        this.logInvocationException(targetMethod, cause);
        if (rpcRequest != null) {
            String failurePayload = RPC.encodeResponseForFailure((Method)rpcRequest.getMethod(), (Throwable)cause, (SerializationPolicy)rpcRequest.getSerializationPolicy());
            return failurePayload;
        }
        return RPC.encodeResponseForFailure(null, (Throwable)cause);
    }

    private void logInvocationException(Method targetMethod, Exception cause) {
        Level level;
        String methodDescription = String.format("Invoking method '%s' failed.", targetMethod == null ? "<unknown>" : MethodUtils.describeMethod(targetMethod));
        Level level2 = level = SESSION_EXP_MSG.equals(cause.getMessage()) ? Level.WARN : Level.ERROR;
        if (cause instanceof IOptionalStackTraceLoggingException) {
            operationLog.log(level, String.valueOf(methodDescription) + ": " + cause.getMessage());
        } else {
            operationLog.log(level, methodDescription, cause);
        }
    }

    private final String handleExporterProcessingException(Exception e) {
        GWTRPCServiceExporter.logException(e);
        throw CheckedExceptionTunnel.wrapIfNecessary(e);
    }

    protected abstract Object getService();

    public final void setServletConfig(ServletConfig servletConfig) {
        assert (servletConfig != null);
        if (operationLog.isTraceEnabled()) {
            String message = "Setting servlet config for class '" + ((Object)((Object)this)).getClass().getSimpleName() + "'.";
            operationLog.trace(message);
        }
        this.servletConfig = servletConfig;
    }

    public final void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public final void afterPropertiesSet() throws Exception {
        LogInitializer.init();
        if (this.getService() == null) {
            throw new ServletException("You must specify a service object.");
        }
        if (operationLog.isTraceEnabled()) {
            String message = "All the properties have been set for bean '" + this.beanName + "'. Time to initialize this servlet.";
            operationLog.trace(message);
        }
        this.init(this.servletConfig);
    }

    public final ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    protected void doUnexpectedFailure(Throwable throwable) {
        operationLog.error("Unexpected throwable", throwable);
        super.doUnexpectedFailure(throwable);
    }

    public final String processCall(String payload) throws SerializationException {
        try {
            RPCRequest request = null;
            Method targetMethod = null;
            try {
                request = RPC.decodeRequest((String)payload, this.getService().getClass(), (SerializationPolicyProvider)this);
                targetMethod = this.getMethodToInvoke(request.getMethod());
                Object[] targetParameters = request.getParameters();
                return this.invokeMethodOnService(targetMethod, targetParameters, request);
            }
            catch (RuntimeException e) {
                return this.handleInvocationException(e, targetMethod, request);
            }
        }
        catch (IncompatibleRemoteServiceException e) {
            return this.handleIncompatibleRemoteServiceException(e);
        }
        catch (Exception e) {
            return this.handleExporterProcessingException(e);
        }
    }

    public final ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doPost(request, response);
        return null;
    }
}

