/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import com.izforge.izpack.api.data.AutomatedInstallData;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

public abstract class AbstractScriptExecutor {
    protected static final String INSTALL_BIN_PATH_VARNAME = "INSTALL_BIN_PATH";

    protected String getAdminScript(AutomatedInstallData data, String scriptFileName) {
        File adminScriptFile = this.getAdminScriptFile(data, scriptFileName);
        return adminScriptFile.getAbsolutePath();
    }

    protected File getAdminScriptFile(AutomatedInstallData data, String scriptFileName) {
        return new File(data.getVariable(INSTALL_BIN_PATH_VARNAME), scriptFileName);
    }

    protected void executeAdminScript(Map<String, String> customEnv, String ... command) {
        this.executeAdminScript(customEnv, System.out, System.err, command);
    }

    protected void executeAdminScript(Map<String, String> customEnv, OutputStream out, OutputStream err, String ... command) {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.environment().putAll(System.getenv());
        if (customEnv != null) {
            pb.environment().putAll(customEnv);
        }
        try {
            Process process = pb.start();
            this.pipe(process.getErrorStream(), err);
            this.pipe(process.getInputStream(), out);
            int returnValue = process.waitFor();
            if (returnValue != 0) {
                System.err.println("Executing of command " + pb.command() + " has failed. Aborting ...");
                System.exit(returnValue);
            }
        }
        catch (Exception e) {
            System.out.println("Error executing " + command[0] + ": " + e.getMessage());
        }
    }

    private void pipe(final InputStream src, final OutputStream dest) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[1024];
                    int n = 0;
                    while (n != -1) {
                        dest.write(buffer, 0, n);
                        n = src.read(buffer);
                    }
                }
                catch (IOException iOException) {}
            }
        }).start();
    }
}

