/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.PrepareInstallationBackupAction;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.DynamicInstallerRequirementValidator;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.data.PanelAction;
import java.util.ArrayList;
import java.util.List;

public class InitializeInstallationContextAction
implements PanelAction {
    private static final DynamicInstallerRequirementValidator DUMMY_VALIDATOR = new DynamicInstallerRequirementValidator(){

        @Override
        public DataValidator.Status validateData(AutomatedInstallData idata) {
            return DataValidator.Status.OK;
        }

        @Override
        public String getWarningMessageId() {
            return "";
        }

        @Override
        public String getErrorMessageId() {
            return "";
        }

        @Override
        public boolean getDefaultAnswer() {
            return true;
        }
    };
    private static final String ROOT_USERNAME = "root";

    @Override
    public void executeAction(AutomatedInstallData data, AbstractUIHandler arg1) {
        this.abortIfRunningAsRoot();
        List<DynamicInstallerRequirementValidator> reqs = data.getDynamicinstallerrequirements();
        if (reqs == null) {
            reqs = new ArrayList<DynamicInstallerRequirementValidator>();
            data.setDynamicinstallerrequirements(reqs);
        }
        reqs.add(DUMMY_VALIDATOR);
        GlobalInstallationContext.initialize(data);
        if (GlobalInstallationContext.isUpdateInstallation) {
            new PrepareInstallationBackupAction().executeAction(data, arg1);
        }
    }

    private void abortIfRunningAsRoot() {
        String userName = System.getProperty("user.name");
        if (ROOT_USERNAME.equalsIgnoreCase(userName)) {
            System.err.println("The openBIS installation cannot be executed as 'root'. Please switch to a user with lower privilidges.");
            System.exit(1);
        }
    }

    @Override
    public void initialize(PanelActionConfiguration arg0) {
    }
}

