/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;

public class KeystoreAction
implements PanelAction {
    private static final String DEFAULT_PASSWORD = "changeit";
    private static final String DEFAULT_KEY_PASSWORD = "changeit";

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    @Override
    public void executeAction(AutomatedInstallData data, AbstractUIHandler handler) {
        data.setVariable("KEY_STORE_PASSWORD", this.getDssServiceProperty("keystore.password", "changeit"));
        data.setVariable("KEY_PASSWORD", this.getDssServiceProperty("keystore.key-password", "changeit"));
        String keyStoreFilePath = data.getVariable("KEY_STORE_FILE");
        GlobalInstallationContext.presentKeyStoreFile = keyStoreFilePath != null && keyStoreFilePath.length() > 0;
    }

    public String getDssServiceProperty(String propertyKey, String defaultValue) {
        String property = Utils.tryToGetServicePropertyOfDSS(GlobalInstallationContext.installDir, propertyKey);
        return property == null ? defaultValue : property;
    }
}

