/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.openbis.installer.izpack.AbstractDataValidator;
import ch.systemsx.cisd.openbis.installer.izpack.PostgresInstallationDetectorUtils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.File;

public class PostgresToolsPathValidator
extends AbstractDataValidator {
    @Override
    public boolean getDefaultAnswer() {
        return true;
    }

    @Override
    public String getErrorMessageId() {
        return "'psql' and 'pg_dump' must be available on the specified path.";
    }

    @Override
    public String getWarningMessageId() {
        return this.getErrorMessageId();
    }

    @Override
    public DataValidator.Status validateData(AutomatedInstallData data) {
        String selectedPath = data.getVariable("POSTGRES_BIN");
        boolean valid = PostgresInstallationDetectorUtils.areCommandLineToolsInDir(selectedPath);
        if (!valid) {
            selectedPath = new File(selectedPath, "bin").getAbsolutePath();
            valid = PostgresInstallationDetectorUtils.areCommandLineToolsInDir(selectedPath);
        }
        data.setVariable("POSTGRES_BIN", selectedPath);
        if (valid) {
            return DataValidator.Status.OK;
        }
        this.setErrorMessage("'psql' and 'pg_dump' must be available on the specified path: " + selectedPath);
        return DataValidator.Status.ERROR;
    }
}

