/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PrepareInstallationBackupAction
implements PanelAction {
    private static final String BACK_FOLDER_PATTERN = "yyMMdd-HHmm";
    private static final String BACKUP_ROOT = "backup";
    private File installDir;
    private File backupDir;

    @Override
    public synchronized void executeAction(AutomatedInstallData data, AbstractUIHandler arg1) {
        if (GlobalInstallationContext.isUpdateInstallation) {
            this.installDir = GlobalInstallationContext.installDir;
            this.backupDir = this.generateUniqueBackupDirName();
            this.setInstallationWideBackupDirVariable(data);
        }
    }

    @Override
    public void initialize(PanelActionConfiguration arg0) {
    }

    private String setInstallationWideBackupDirVariable(AutomatedInstallData data) {
        String backupDirPath = this.backupDir.getAbsolutePath();
        data.setVariable("BACKUP_FOLDER", backupDirPath);
        return backupDirPath;
    }

    private File generateUniqueBackupDirName() {
        File backupRootDir = new File(this.installDir, BACKUP_ROOT);
        Date now = new Date();
        String backupDirName = new SimpleDateFormat(BACK_FOLDER_PATTERN).format(now);
        File result = new File(backupRootDir, backupDirName);
        int uniqueSuffix = 1;
        while (result.exists()) {
            result = new File(backupRootDir, String.valueOf(backupDirName) + "-" + uniqueSuffix);
            ++uniqueSuffix;
        }
        return result;
    }
}

