/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.SetTechnologyCheckBoxesAction;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.util.HashSet;
import java.util.Properties;

public class SetEnableTechnologiesVariableAction
implements PanelAction {
    static final String ENABLED_TECHNOLOGIES_VARNAME = "ENABLED_TECHNOLOGIES";
    private final SetTechnologyCheckBoxesAction technologyCheckBoxesAction = new SetTechnologyCheckBoxesAction();

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    @Override
    public void executeAction(AutomatedInstallData data, AbstractUIHandler handler) {
        this.technologyCheckBoxesAction.executeAction(data, handler);
        boolean isFirstTimeInstallation = GlobalInstallationContext.isFirstTimeInstallation;
        File installDir = GlobalInstallationContext.installDir;
        this.updateEnabledTechnologyProperty(data, isFirstTimeInstallation, installDir);
    }

    void updateEnabledTechnologyProperty(AutomatedInstallData data, boolean isFirstTimeInstallation, File installDir) {
        String newTechnologyList = this.createListOfEnabledTechnologies(data);
        data.setVariable(ENABLED_TECHNOLOGIES_VARNAME, newTechnologyList);
        File corePluginPropertiesFile = new File(installDir, "servers/core-plugins/core-plugins.properties");
        corePluginPropertiesFile.getParentFile().mkdirs();
        this.modifyPropertyEnabledTechnologies(corePluginPropertiesFile, data);
    }

    private String createListOfEnabledTechnologies(AutomatedInstallData data) {
        CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
        String[] stringArray = GlobalInstallationContext.TECHNOLOGIES;
        int n = GlobalInstallationContext.TECHNOLOGIES.length;
        int n2 = 0;
        while (n2 < n) {
            String technology = stringArray[n2];
            String technologyFlag = data.getVariable(technology);
            if (Boolean.TRUE.toString().equalsIgnoreCase(technologyFlag)) {
                builder.append(technology.toLowerCase());
            }
            ++n2;
        }
        return builder.toString();
    }

    private void modifyPropertyEnabledTechnologies(File configFile, AutomatedInstallData data) {
        String property;
        HashSet<String> allTechnologies = new HashSet<String>();
        CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
        String[] stringArray = GlobalInstallationContext.TECHNOLOGIES;
        int n = GlobalInstallationContext.TECHNOLOGIES.length;
        int n2 = 0;
        while (n2 < n) {
            String technology = stringArray[n2];
            String lowerCasedTechnology = technology.toLowerCase();
            allTechnologies.add(lowerCasedTechnology);
            String technologyFlag = data.getVariable(technology);
            if (Boolean.TRUE.toString().equalsIgnoreCase(technologyFlag)) {
                builder.append(lowerCasedTechnology);
            }
            ++n2;
        }
        Properties properties = Utils.tryToGetProperties(configFile);
        if (properties != null && (property = properties.getProperty("enabled-modules")) != null && property.trim().length() > 0) {
            String[] splittedProperty;
            String[] stringArray2 = splittedProperty = property.split(",");
            int n3 = splittedProperty.length;
            int n4 = 0;
            while (n4 < n3) {
                String term = stringArray2[n4];
                String trimmedTerm = term.trim();
                if (!allTechnologies.contains(trimmedTerm)) {
                    builder.append(trimmedTerm);
                }
                ++n4;
            }
        }
        Utils.updateOrAppendProperty(configFile, "enabled-modules", builder.toString());
    }
}

