/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.net.InetAddress;

public class SetHostnameVariableAction
implements PanelAction {
    private static final String INSTALLATION_TYPE_VARNAME = "INSTALLATION_TYPE";
    private static final String HOSTNAME_VARNAME = "HOSTNAME";
    private static final String SERVER_INSTALLATION_TYPE = "server";

    @Override
    public synchronized void executeAction(AutomatedInstallData data, AbstractUIHandler arg1) {
        String installationType = data.getVariable(INSTALLATION_TYPE_VARNAME);
        if (SERVER_INSTALLATION_TYPE.equalsIgnoreCase(installationType)) {
            data.setVariable(HOSTNAME_VARNAME, SetHostnameVariableAction.tryGetCannonicalHostName());
        } else {
            data.setVariable(HOSTNAME_VARNAME, SetHostnameVariableAction.tryGetHostName());
        }
    }

    @Override
    public void initialize(PanelActionConfiguration arg0) {
    }

    private static String tryGetCannonicalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception exception) {
            return SetHostnameVariableAction.tryGetHostName();
        }
    }

    private static String tryGetHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }
}

