/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.openbis.installer.izpack.GlobalInstallationContext;
import ch.systemsx.cisd.openbis.installer.izpack.Utils;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class SetTechnologyCheckBoxesAction
implements PanelAction {
    static final String ENABLED_TECHNOLOGIES_KEY_LEGACY = "enabled-technologies";
    static final String ENABLED_TECHNOLOGIES_KEY = "enabled-modules";
    private final Map<String, ITechnologyChecker> technologyCheckers = new HashMap<String, ITechnologyChecker>();

    public SetTechnologyCheckBoxesAction() {
        String[] stringArray = GlobalInstallationContext.TECHNOLOGIES;
        int n = GlobalInstallationContext.TECHNOLOGIES.length;
        int n2 = 0;
        while (n2 < n) {
            String technology = stringArray[n2];
            this.registerTechnologyChecker(new SimpleTechnologyChecker(technology));
            ++n2;
        }
    }

    private void registerTechnologyChecker(ITechnologyChecker checker) {
        this.technologyCheckers.put(checker.getTechnologyName(), checker);
    }

    @Override
    public void initialize(PanelActionConfiguration configuration) {
    }

    @Override
    public void executeAction(AutomatedInstallData data, AbstractUIHandler handler) {
        String[] stringArray = GlobalInstallationContext.TECHNOLOGIES;
        int n = GlobalInstallationContext.TECHNOLOGIES.length;
        int n2 = 0;
        while (n2 < n) {
            String technology = stringArray[n2];
            String variable = data.getVariable(technology);
            if (variable == null) {
                boolean technologyFlag = false;
                if (GlobalInstallationContext.isUpdateInstallation) {
                    technologyFlag = this.isTechnologyEnabled(GlobalInstallationContext.installDir, technology);
                }
                data.setVariable(technology, Boolean.toString(technologyFlag));
            }
            ++n2;
        }
    }

    boolean isTechnologyEnabled(File installDir, String technology) {
        ITechnologyChecker technologyChecker = this.technologyCheckers.get(technology);
        if (technologyChecker == null) {
            return false;
        }
        return technologyChecker.isTechnologyEnabled(installDir);
    }

    private static interface ITechnologyChecker {
        public String getTechnologyName();

        public boolean isTechnologyEnabled(File var1);
    }

    private static final class SimpleTechnologyChecker
    implements ITechnologyChecker {
        private final String technologyName;

        SimpleTechnologyChecker(String technologyName) {
            this.technologyName = technologyName;
        }

        @Override
        public String getTechnologyName() {
            return this.technologyName;
        }

        @Override
        public boolean isTechnologyEnabled(File installDir) {
            String technologies = Utils.tryToGetCorePluginsProperty(installDir, SetTechnologyCheckBoxesAction.ENABLED_TECHNOLOGIES_KEY);
            if (technologies == null) {
                technologies = Utils.tryToGetCorePluginsProperty(installDir, SetTechnologyCheckBoxesAction.ENABLED_TECHNOLOGIES_KEY_LEGACY);
            }
            if (technologies == null) {
                technologies = Utils.tryToGetServicePropertyOfAS(installDir, SetTechnologyCheckBoxesAction.ENABLED_TECHNOLOGIES_KEY);
            }
            if (technologies == null) {
                technologies = Utils.tryToGetServicePropertyOfAS(installDir, SetTechnologyCheckBoxesAction.ENABLED_TECHNOLOGIES_KEY_LEGACY);
            }
            if (technologies != null) {
                return technologies.contains(this.technologyName.toLowerCase());
            }
            return false;
        }
    }
}

