/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.installer.izpack;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.shared.basic.string.CommaSeparatedListBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

class Utils {
    private static final String SERVERS_PATH = "servers/";
    static final String CORE_PLUGINS_PATH = "servers/core-plugins/";
    static final String AS_PATH = "servers/openBIS-server/jetty/";
    static final String DSS_PATH = "servers/datastore_server/";
    static final String SERVICE_PROPERTIES_PATH = "etc/service.properties";
    static final String CORE_PLUGINS_PROPERTIES_PATH = "servers/core-plugins/core-plugins.properties";
    static final String JETTY_XML_PATH = "etc/jetty.xml";
    static final String KEYSTORE_PATH = "etc/openBIS.keystore";
    static final String DSS_KEYSTORE_KEY_PASSWORD_KEY = "keystore.key-password";
    static final String DSS_KEYSTORE_PASSWORD_KEY = "keystore.password";

    Utils() {
    }

    static boolean hasCorePluginsFolder(File installDir) {
        return new File(installDir, CORE_PLUGINS_PATH).isDirectory();
    }

    static String tryToGetServicePropertyOfAS(File installDir, String propertyKey) {
        Properties serviceProperties = Utils.tryToGetServicePropertiesOfAS(installDir);
        return serviceProperties == null ? null : serviceProperties.getProperty(propertyKey);
    }

    static String tryToGetCorePluginsProperty(File installDir, String propertyKey) {
        Properties serviceProperties = Utils.tryToGetCorePluginsProperties(installDir);
        return serviceProperties == null ? null : serviceProperties.getProperty(propertyKey);
    }

    static String tryToGetServicePropertyOfDSS(File installDir, String propertyKey) {
        Properties serviceProperties = Utils.tryToGetServicePropertiesOfDSS(installDir);
        return serviceProperties == null ? null : serviceProperties.getProperty(propertyKey);
    }

    static boolean dssPropertiesContains(File installDir, String string) {
        Properties properties = Utils.tryToGetServiceProperties(installDir, "servers/datastore_server/etc/service.properties");
        if (properties == null) {
            return false;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            if (key.toLowerCase().contains(string)) {
                return true;
            }
            String value = entry.getValue().toString();
            if (!value.toLowerCase().contains(string)) continue;
            return true;
        }
        return false;
    }

    private static Properties tryToGetServicePropertiesOfAS(File installDir) {
        return Utils.tryToGetServiceProperties(installDir, "servers/openBIS-server/jetty/etc/service.properties");
    }

    private static Properties tryToGetCorePluginsProperties(File installDir) {
        return Utils.tryToGetServiceProperties(installDir, CORE_PLUGINS_PROPERTIES_PATH);
    }

    private static Properties tryToGetServicePropertiesOfDSS(File installDir) {
        return Utils.tryToGetServiceProperties(installDir, "servers/datastore_server/etc/service.properties");
    }

    private static Properties tryToGetServiceProperties(File installDir, String relativePath) {
        return Utils.tryToGetProperties(new File(installDir, relativePath));
    }

    public static Properties tryToGetProperties(File configFile) {
        Properties properties;
        Properties properties2 = new Properties();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(configFile);
            properties2.load(fileReader);
            properties = properties2;
        }
        catch (Exception exception) {
            try {}
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileReader);
                throw throwable;
            }
            IOUtils.closeQuietly(fileReader);
            return null;
        }
        IOUtils.closeQuietly(fileReader);
        return properties;
    }

    static void updateConfigFile(File configFile, List<String> list) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(configFile);
                for (String line : list) {
                    printWriter.println(line);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Couldn't update " + configFile, ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(printWriter);
            throw throwable;
        }
        IOUtils.closeQuietly(printWriter);
    }

    static void appendEntryToConfigFile(File configFile, String propertiesEntry) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new PrintWriter(new FileWriter(configFile, true));
                printWriter.println();
                printWriter.println(propertiesEntry);
                printWriter.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("Couldn't append property enabled-modules to " + configFile, ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(printWriter);
            throw throwable;
        }
        IOUtils.closeQuietly(printWriter);
    }

    static void updateOrAppendProperty(File configFile, String propertyKey, String propertyValue) {
        ArrayList<String> list = configFile.exists() ? FileUtilities.loadToStringList(configFile) : new ArrayList<String>();
        boolean defined = false;
        boolean unchanged = false;
        String propertiesEntry = String.valueOf(propertyKey) + " = " + propertyValue;
        int i = 0;
        while (i < list.size()) {
            String line = (String)list.get(i);
            if (line.startsWith(propertyKey)) {
                defined = true;
                String currentPropertyValue = line.substring(propertyKey.length()).trim();
                if (currentPropertyValue.startsWith("=")) {
                    currentPropertyValue = currentPropertyValue.substring(1).trim();
                }
                if (unchanged = currentPropertyValue.equals(propertyValue)) break;
                list.set(i, propertiesEntry);
                break;
            }
            ++i;
        }
        if (defined) {
            if (!unchanged) {
                Utils.updateConfigFile(configFile, list);
            }
        } else {
            Utils.appendEntryToConfigFile(configFile, propertiesEntry);
        }
    }

    static void addTermToPropertyList(File configFile, String propertyKey, String newTerm) {
        Properties properties = Utils.tryToGetProperties(configFile);
        if (properties == null) {
            return;
        }
        String property = properties.getProperty(propertyKey);
        CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
        if (property != null) {
            String[] terms;
            String[] stringArray = terms = property.split(",");
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                String term = stringArray[n2];
                String trimmedTerm = term.trim();
                if (trimmedTerm.equals(newTerm)) {
                    return;
                }
                builder.append(trimmedTerm);
                ++n2;
            }
        }
        builder.append(newTerm);
        Utils.updateOrAppendProperty(configFile, propertyKey, builder.toString());
    }

    static void removeTermFromPropertyList(File configFile, String propertyKey, String termToRemove) {
        Properties properties = Utils.tryToGetProperties(configFile);
        if (properties == null) {
            return;
        }
        String property = properties.getProperty(propertyKey);
        CommaSeparatedListBuilder builder = new CommaSeparatedListBuilder();
        if (property != null) {
            String[] terms;
            String[] stringArray = terms = property.split(",");
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                String term = stringArray[n2];
                String trimmedTerm = term.trim();
                if (!trimmedTerm.equals(termToRemove)) {
                    builder.append(trimmedTerm);
                }
                ++n2;
            }
        }
        Utils.updateOrAppendProperty(configFile, propertyKey, builder.toString());
    }

    static File getKeystoreFileForDSS(File installDir) {
        return new File(installDir, "servers/datastore_server/etc/openBIS.keystore");
    }

    static File getKeystoreFileForAS(File installDir) {
        return new File(installDir, "servers/openBIS-server/jetty/etc/openBIS.keystore");
    }

    static boolean isASInstalled(File installDir) {
        return new File(installDir, AS_PATH).exists();
    }
}

