/*
 * Decompiled with CFR 0.152.
 */
package com.coi.tools.os.win;

import com.coi.tools.os.win.MSWinConstants;
import java.io.Serializable;

public class RegDataContainer
implements Cloneable,
Serializable,
MSWinConstants {
    private static final long serialVersionUID = 3979265850388066865L;
    private static final int[] VALID_TYPES;
    private long dwordData = 0L;
    private String stringData = null;
    private String[] multiStringData = null;
    private byte[] binData = null;
    private int type = 0;

    static {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 6;
        nArray[6] = 7;
        VALID_TYPES = nArray;
    }

    public RegDataContainer() {
    }

    public RegDataContainer(int type) throws IllegalArgumentException {
        if (!this.isValidType(type)) {
            throw new IllegalArgumentException("Type is not valid");
        }
        this.type = type;
    }

    public RegDataContainer(long data) {
        this.type = 4;
        this.dwordData = data;
    }

    public RegDataContainer(String data) {
        if (this.containsPlaceholder(data)) {
            this.setType(2);
        } else {
            this.setType(1);
        }
        this.stringData = data;
    }

    public RegDataContainer(String[] data) {
        this.type = 7;
        this.multiStringData = data;
    }

    public RegDataContainer(byte[] data) {
        this.type = 3;
        this.binData = data;
    }

    public byte[] getBinData() {
        return this.binData;
    }

    public long getDwordData() {
        return this.dwordData;
    }

    public String[] getMultiStringData() {
        return this.multiStringData;
    }

    public String getStringData() {
        return this.stringData;
    }

    public int getType() {
        return this.type;
    }

    public void setBinData(byte[] bytes) {
        this.binData = bytes;
    }

    public void setDwordData(long dwordData) {
        this.dwordData = dwordData;
    }

    public void setMultiStringData(String[] strings) {
        this.multiStringData = strings;
    }

    public void setStringData(String stringData) {
        this.stringData = stringData;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isValidType(int type) {
        int[] nArray = VALID_TYPES;
        int n = VALID_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            int validType = nArray[n2];
            if (type == validType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Object getDataAsObject() {
        switch (this.type) {
            case 1: 
            case 2: {
                return this.getStringData();
            }
            case 3: {
                return this.getBinData();
            }
            case 4: {
                return this.getDwordData();
            }
            case 7: {
                return this.getMultiStringData();
            }
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        RegDataContainer retval = (RegDataContainer)super.clone();
        if (this.multiStringData != null) {
            retval.multiStringData = new String[this.multiStringData.length];
            System.arraycopy(this.multiStringData, 0, retval.multiStringData, 0, this.multiStringData.length);
        }
        if (this.binData != null) {
            retval.binData = new byte[this.binData.length];
            System.arraycopy(this.binData, 0, retval.binData, 0, this.binData.length);
        }
        return retval;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof RegDataContainer) {
            RegDataContainer other = (RegDataContainer)anObject;
            if (other.type != this.type) {
                return false;
            }
            switch (this.type) {
                case 4: {
                    return other.dwordData == this.dwordData;
                }
                case 1: 
                case 2: {
                    if (this.stringData == null) {
                        return other.stringData == null;
                    }
                    return this.stringData.equals(other.stringData);
                }
                case 3: {
                    if (this.binData == null) {
                        return other.binData == null;
                    }
                    if (other.binData != null && this.binData.length == other.binData.length) {
                        int i = 0;
                        while (i < this.binData.length) {
                            if (this.binData[i] != other.binData[i]) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                    return false;
                }
                case 7: {
                    if (this.multiStringData == null) {
                        return other.multiStringData == null;
                    }
                    if (other.multiStringData != null && this.multiStringData.length == other.multiStringData.length) {
                        int i = 0;
                        while (i < this.multiStringData.length) {
                            if (this.multiStringData[i] != null ? !this.multiStringData[i].equals(other.multiStringData[i]) : other.multiStringData[i] == null) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int result = (int)(this.dwordData ^ this.dwordData >>> 32);
        result = 29 * result + (this.stringData != null ? this.stringData.hashCode() : 0);
        result = 29 * result + this.type;
        return result;
    }

    private boolean containsPlaceholder(String str) {
        return str.contains("%");
    }
}

