/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.container.filler;

import com.izforge.izpack.api.container.BindeableContainer;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.data.binding.IzpackProjectInstaller;
import com.izforge.izpack.api.data.binding.Listener;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.merge.resolve.ClassPathCrawler;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;

public class EventFiller {
    private ResourceManager resourceManager;
    private ClassPathCrawler classPathCrawler;
    private BindeableContainer bindeableContainer;
    private AutomatedInstallData installdata;

    public EventFiller(ResourceManager resourceManager, ClassPathCrawler classPathCrawler, BindeableContainer bindeableContainer, AutomatedInstallData installdata) {
        this.resourceManager = resourceManager;
        this.classPathCrawler = classPathCrawler;
        this.bindeableContainer = bindeableContainer;
        this.installdata = installdata;
    }

    public void loadCustomData() {
        try {
            IzpackProjectInstaller izpackModel = (IzpackProjectInstaller)this.readObject("izpackInstallModel");
            ArrayList<InstallerListener> customActions = new ArrayList<InstallerListener>();
            for (Listener listener : izpackModel.getListeners()) {
                if (!OsConstraintHelper.oneMatchesCurrentSystem(listener.getOs())) continue;
                switch (listener.getStage()) {
                    case install: {
                        Class aClass = this.classPathCrawler.searchClassInClassPath(listener.getClassname());
                        this.bindeableContainer.addComponent(aClass);
                        customActions.add((InstallerListener)this.bindeableContainer.getComponent(aClass));
                    }
                }
            }
            this.installdata.setInstallerListener(customActions);
        }
        catch (IOException e) {
            throw new IzPackException("Error when reading custom data (events)", e);
        }
        catch (ClassNotFoundException e) {
            throw new IzPackException("Error when reading custom data (events)", e);
        }
    }

    public Object readObject(String resourceId) throws IOException, ClassNotFoundException {
        InputStream inputStream = this.resourceManager.getInputStream(resourceId);
        ObjectInputStream objIn = new ObjectInputStream(inputStream);
        Object model = objIn.readObject();
        objIn.close();
        return model;
    }
}

