/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.logic;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.util.Debug;

public class NotCondition
extends Condition {
    private static final long serialVersionUID = 3194843222487006309L;
    protected Condition operand;
    private RulesEngine rulesEngineImpl;

    public NotCondition(RulesEngine rulesEngineImpl) {
        this.rulesEngineImpl = rulesEngineImpl;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition.getChildrenCount() <= 0) {
            throw new Exception("Missing nested element in condition \"" + this.getId() + "\"");
        }
        if (xmlcondition.getChildrenCount() != 1) {
            throw new Exception("Condition \"" + this.getId() + "\" needs exactly one condition as operand");
        }
        this.operand = this.rulesEngineImpl.instanciateCondition(xmlcondition.getChildAtIndex(0));
    }

    @Override
    public boolean isTrue() {
        if (this.operand == null) {
            Debug.trace("Operand of condition " + this.getId() + " not initialized correctly.");
            return false;
        }
        this.operand.setInstalldata(this.getInstallData());
        return !this.operand.isTrue();
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on:<ul><li>NOT ");
        details.append(this.operand.getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        IXMLElement conditionElement = this.rulesEngineImpl.createConditionElement(this.operand, conditionRoot);
        this.operand.makeXMLData(conditionElement);
        conditionRoot.addChild(conditionElement);
    }

    public static Condition createFromCondition(Condition conditionByExpr, RulesEngine rulesEngine, AutomatedInstallData installData) {
        NotCondition notCondition = new NotCondition(rulesEngine);
        notCondition.setInstalldata(installData);
        notCondition.operand = conditionByExpr;
        if (conditionByExpr != null) {
            notCondition.operand.setInstalldata(installData);
        }
        return notCondition;
    }
}

