/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.logic;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.core.rules.RulesEngineImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class OrCondition
extends Condition {
    private static final long serialVersionUID = 8341350377205144199L;
    protected RulesEngineImpl rulesEngineImpl;
    protected Collection<Condition> nestedConditions = new ArrayList<Condition>();

    public OrCondition(RulesEngineImpl rulesEngineImpl, Condition ... operands) {
        this.rulesEngineImpl = rulesEngineImpl;
        this.nestedConditions.addAll(Arrays.asList(operands));
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        if (xmlcondition.getChildrenCount() <= 0) {
            throw new Exception("Missing element in condition \"" + this.getId() + "\"");
        }
        for (IXMLElement element : xmlcondition.getChildren()) {
            this.nestedConditions.add(this.rulesEngineImpl.instanciateCondition(element));
        }
    }

    @Override
    public boolean isTrue() {
        boolean result = false;
        for (Condition condition : this.nestedConditions) {
            condition.setInstalldata(this.getInstallData());
            boolean bl = result = result || condition.isTrue();
        }
        return result;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on:<ul><li>");
        for (Condition condition : this.nestedConditions) {
            details.append(condition.getDependenciesDetails());
            details.append("</li> OR <li>");
        }
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        for (Condition condition : this.nestedConditions) {
            IXMLElement left = this.rulesEngineImpl.createConditionElement(condition, conditionRoot);
            condition.makeXMLData(left);
            conditionRoot.addChild(left);
        }
    }
}

