/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.core.rules.process.ComparisonOperator;
import com.izforge.izpack.util.Debug;

public class ComparenumericsCondition
extends Condition {
    private static final long serialVersionUID = 5631805710151645907L;
    protected String variablename;
    protected String value;
    protected ComparisonOperator operator = ComparisonOperator.EQUAL;

    public ComparenumericsCondition(String variablename, String value) {
        this.variablename = variablename;
        this.value = value;
    }

    public ComparenumericsCondition() {
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getVariablename() {
        return this.variablename;
    }

    public void setVariablename(String variablename) {
        this.variablename = variablename;
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ComparisonOperator operator) {
        this.operator = operator;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        this.variablename = xmlcondition.getFirstChildNamed("name").getContent();
        if (this.variablename == null) {
            throw new Exception("Missing \"name\" element in condition \"" + this.getId() + "\"");
        }
        this.value = xmlcondition.getFirstChildNamed("value").getContent();
        if (this.value == null) {
            throw new Exception("Missing \"value\" element in condition \"" + this.getId() + "\"");
        }
        String operatorAttr = xmlcondition.getFirstChildNamed("operator").getContent();
        if (operatorAttr != null) {
            this.operator = ComparisonOperator.getComparisonOperatorFromAttribute(operatorAttr);
            if (this.operator == null) {
                throw new Exception("Unknown \"operator\" element value \"" + operatorAttr + "\" in condition \"" + this.getId() + "\"");
            }
        } else {
            throw new Exception("Missing \"operator\" element in condition \"" + this.getId() + "\"");
        }
    }

    @Override
    public boolean isTrue() {
        String val;
        boolean result = false;
        if (this.getInstallData() != null && (val = this.getInstallData().getVariable(this.variablename)) != null) {
            if (this.operator == null) {
                this.operator = ComparisonOperator.EQUAL;
            }
            try {
                int currentValue = new Integer(val);
                int comparisonValue = new Integer(this.value);
                switch (this.operator) {
                    case EQUAL: {
                        result = currentValue == comparisonValue;
                        break;
                    }
                    case NOTEQUAL: {
                        result = currentValue != comparisonValue;
                        break;
                    }
                    case GREATER: {
                        result = currentValue > comparisonValue;
                        break;
                    }
                    case GREATEREQUAL: {
                        result = currentValue >= comparisonValue;
                        break;
                    }
                    case LESS: {
                        result = currentValue < comparisonValue;
                        break;
                    }
                    case LESSEQUAL: {
                        result = currentValue <= comparisonValue;
                        break;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                Debug.log("The value of the associated variable is not a numeric value or the value which should be compared is not a number.");
            }
        }
        return result;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on a value of <b>");
        details.append(this.value);
        details.append("</b> on variable <b>");
        details.append(this.variablename);
        details.append(" (current value: ");
        details.append(this.getInstallData().getVariable(this.variablename));
        details.append(")");
        details.append("This value has to be " + (Object)((Object)this.operator));
        details.append("</b><br/>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl nameXml = new XMLElementImpl("name", conditionRoot);
        nameXml.setContent(this.variablename);
        conditionRoot.addChild(nameXml);
        XMLElementImpl valueXml = new XMLElementImpl("value", conditionRoot);
        valueXml.setContent(this.value);
        conditionRoot.addChild(valueXml);
        XMLElementImpl opXml = new XMLElementImpl("op", conditionRoot);
        opXml.setContent(this.operator.getAttribute());
        conditionRoot.addChild(opXml);
    }
}

