/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;

public class RefCondition
extends Condition {
    private static final long serialVersionUID = -2880915036530702269L;
    Condition referencedcondition;
    private String referencedConditionId;
    private RulesEngine rules;

    public RefCondition(RulesEngine rules) {
        this.rules = rules;
        this.referencedcondition = null;
        this.referencedConditionId = null;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        this.referencedConditionId = xmlcondition.getAttribute("refid");
        if (this.referencedConditionId == null) {
            throw new Exception("Missing attribute \"refid\" in condition \"" + this.getId() + "\"");
        }
        this.referencedcondition = this.rules.getCondition(this.referencedConditionId);
        if (this.referencedcondition == null) {
            throw new Exception("Condition \"" + this.referencedConditionId + "\" referenced from condition \"" + this.getId() + "\" does not exist");
        }
        this.setId("ref." + this.referencedConditionId);
    }

    @Override
    public boolean isTrue() {
        if (this.referencedConditionId == null) {
            return false;
        }
        if (this.referencedcondition == null) {
            this.referencedcondition = this.rules.getCondition(this.referencedConditionId);
        }
        if (this.referencedcondition != null) {
            this.referencedcondition.setInstalldata(this.getInstallData());
        }
        return this.referencedcondition != null ? this.referencedcondition.isTrue() : false;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on:<ul><li>");
        details.append(this.referencedcondition.getDependenciesDetails());
        details.append("</li></ul>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        conditionRoot.setAttribute("refid", this.referencedConditionId);
    }
}

