/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;

public class VariableCondition
extends Condition {
    private static final long serialVersionUID = 2881336115632480575L;
    protected String variablename;
    protected String value;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getVariablename() {
        return this.variablename;
    }

    public void setVariablename(String variablename) {
        this.variablename = variablename;
    }

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        try {
            this.variablename = xmlcondition.getFirstChildNamed("name").getContent();
            this.value = xmlcondition.getFirstChildNamed("value").getContent();
        }
        catch (Exception e) {
            throw new Exception("Missing attribute in condition \"" + this.getId() + "\"");
        }
    }

    @Override
    public boolean isTrue() {
        if (this.getInstallData() != null) {
            String val = this.getInstallData().getVariable(this.variablename);
            if (val == null) {
                return false;
            }
            VariableSubstitutorImpl subst = new VariableSubstitutorImpl(this.getInstallData().getVariables());
            return val.equals(subst.substitute(this.value));
        }
        return false;
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append(" depends on a value of <b>");
        details.append(this.value);
        details.append("</b> on variable <b>");
        details.append(this.variablename);
        details.append(" (current value: ");
        details.append(this.getInstallData().getVariable(this.variablename));
        details.append(")");
        details.append("</b><br/>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl nameEl = new XMLElementImpl("name", conditionRoot);
        nameEl.setContent(this.variablename);
        conditionRoot.addChild(nameEl);
        XMLElementImpl valueEl = new XMLElementImpl("value", conditionRoot);
        valueEl.setContent(this.value);
        conditionRoot.addChild(valueEl);
    }
}

