/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.substitutor;

import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.Value;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.substitutor.VariableSubstitutorBase;
import com.izforge.izpack.util.Debug;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DynamicVariableSubstitutor
extends VariableSubstitutorBase
implements Serializable {
    private static final long serialVersionUID = 6585770687685394673L;
    protected transient Map<String, List<DynamicVariable>> dynamicvariables;
    protected RulesEngine rules;

    public DynamicVariableSubstitutor(Map<String, List<DynamicVariable>> dynamicvariables, RulesEngine rules) {
        this.dynamicvariables = dynamicvariables;
        this.rules = rules;
    }

    @Override
    public Value getValue(String name) {
        if (this.dynamicvariables != null) {
            for (String dynvarname : this.dynamicvariables.keySet()) {
                for (DynamicVariable dynvar : this.dynamicvariables.get(dynvarname)) {
                    String conditionid = dynvar.getConditionid();
                    if (conditionid != null && conditionid.length() > 0) {
                        if (this.rules == null || !this.rules.isConditionTrue(conditionid)) continue;
                        Debug.log("refresh condition");
                        return dynvar.getValue();
                    }
                    return dynvar.getValue();
                }
            }
        }
        return null;
    }
}

