/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.variable;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.variable.ValueImpl;
import com.izforge.izpack.util.OsVersion;
import java.io.Serializable;
import org.ini4j.Reg;
import org.ini4j.Registry;

public class RegistryValue
extends ValueImpl
implements Serializable {
    private static final long serialVersionUID = 97879516787269847L;
    public String root;
    public String key;
    public String value;

    public RegistryValue(String root, String key, String value) {
        this.root = root;
        this.key = key;
        this.value = value;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void validate() throws Exception {
        if (this.root == null && this.key == null || this.root != null && this.root.length() <= 0 && this.key != null && this.key.length() <= 0) {
            throw new Exception("No or empty registry key path");
        }
    }

    @Override
    public String resolve() throws Exception {
        if (!OsVersion.IS_WINDOWS) {
            throw new Exception("Registry access allowed only on Windows OS");
        }
        Reg reg = null;
        Registry.Key regkey = null;
        if (this.root != null) {
            reg = new Reg(this.root);
        }
        if (this.key != null) {
            if (reg == null) {
                reg = new Reg();
            }
            regkey = reg.get((Object)this.key);
        }
        if (regkey != null) {
            return (String)regkey.get((Object)this.value);
        }
        return null;
    }

    @Override
    public String resolve(VariableSubstitutor ... substitutors) throws Exception {
        VariableSubstitutor substitutor;
        int n;
        int n2;
        VariableSubstitutor[] variableSubstitutorArray;
        if (!OsVersion.IS_WINDOWS) {
            throw new Exception("Registry access allowed only on Windows OS");
        }
        Reg reg = null;
        Registry.Key regkey = null;
        if (this.root != null) {
            String _root_ = this.root;
            variableSubstitutorArray = substitutors;
            n2 = substitutors.length;
            n = 0;
            while (n < n2) {
                substitutor = variableSubstitutorArray[n];
                _root_ = substitutor.substitute(_root_);
                ++n;
            }
            reg = new Reg(_root_);
        }
        if (this.key != null) {
            if (reg == null) {
                reg = new Reg();
            }
            String _key_ = this.key;
            variableSubstitutorArray = substitutors;
            n2 = substitutors.length;
            n = 0;
            while (n < n2) {
                substitutor = variableSubstitutorArray[n];
                _key_ = substitutor.substitute(_key_);
                ++n;
            }
            regkey = reg.get((Object)_key_);
        }
        if (regkey != null) {
            String _value_ = this.value;
            variableSubstitutorArray = substitutors;
            n2 = substitutors.length;
            n = 0;
            while (n < n2) {
                substitutor = variableSubstitutorArray[n];
                _value_ = substitutor.substitute(_value_);
                ++n;
            }
            return (String)regkey.get((Object)_value_);
        }
        return null;
    }
}

