/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.data;

import com.izforge.izpack.api.data.Blockable;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackColor;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.data.ParsableFile;
import com.izforge.izpack.data.UpdateCheck;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PackInfo
implements Serializable {
    private static final long serialVersionUID = -3604642858885697783L;
    private Pack pack;
    public PackColor colour;
    private Map<PackFile, File> files = new LinkedHashMap<PackFile, File>();
    private List<ParsableFile> parsables = new ArrayList<ParsableFile>();
    private List<ExecutableFile> executables = new ArrayList<ExecutableFile>();
    private List<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();

    public PackInfo(String name, String id, String description, boolean required, boolean loose, String excludegroup, boolean uninstall) {
        boolean ispreselected = excludegroup == null;
        this.pack = new Pack(name, id, description, null, null, required, ispreselected, loose, excludegroup, uninstall);
        this.colour = PackColor.WHITE;
    }

    public void setDependencies(List<String> dependencies) {
        this.pack.dependencies = dependencies;
    }

    public void setExcludeGroup(String group) {
        this.pack.excludeGroup = group;
    }

    public void setOsConstraints(List<OsModel> osConstraints) {
        this.pack.osConstraints = osConstraints;
    }

    public List<OsModel> getOsConstraints(List osConstraints) {
        return this.pack.osConstraints;
    }

    public void setPreselected(boolean preselected) {
        this.pack.preselected = preselected;
    }

    public boolean isPreselected() {
        return this.pack.preselected;
    }

    public String getGroup() {
        return this.pack.group;
    }

    public void setGroup(String group) {
        this.pack.group = group;
    }

    public void addInstallGroup(String group) {
        this.pack.installGroups.add(group);
    }

    public boolean hasInstallGroup(String group) {
        return this.pack.installGroups.contains(group);
    }

    public Set<String> getInstallGroups() {
        return this.pack.installGroups;
    }

    public Pack getPack() {
        return this.pack;
    }

    public boolean isHidden() {
        return this.pack.isHidden();
    }

    public void setHidden(boolean hidden) {
        this.pack.setHidden(hidden);
    }

    public void addFile(File baseDir, File file, String targetfile, List<OsModel> osList, OverrideType override, String overrideRenameTo, Blockable blockable, Map additionals, String condition) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        PackFile packFile = new PackFile(baseDir, file, targetfile, osList, override, overrideRenameTo, blockable, additionals);
        packFile.setLoosePackInfo(this.pack.loose);
        packFile.setCondition(condition);
        this.files.put(packFile, file);
    }

    public Set<PackFile> getPackFiles() {
        return this.files.keySet();
    }

    public File getFile(PackFile packFile) {
        return this.files.get(packFile);
    }

    public void addParsable(ParsableFile parsable) {
        this.parsables.add(parsable);
    }

    public List<ParsableFile> getParsables() {
        return this.parsables;
    }

    public void addExecutable(ExecutableFile executable) {
        this.executables.add(executable);
    }

    public List<ExecutableFile> getExecutables() {
        return this.executables;
    }

    public void addUpdateCheck(UpdateCheck updateCheck) {
        this.updateChecks.add(updateCheck);
    }

    public List<UpdateCheck> getUpdateChecks() {
        return this.updateChecks;
    }

    public void addDependency(String dependency) {
        if (this.pack.dependencies == null) {
            this.pack.dependencies = new ArrayList<String>();
        }
        this.pack.dependencies.add(dependency);
    }

    public List<String> getDependencies() {
        return this.pack.dependencies;
    }

    public String getParent() {
        return this.pack.parent;
    }

    public void setParent(String p) {
        this.pack.parent = p;
    }

    public String toString() {
        return this.pack.name;
    }

    public void setPackImgId(String packImgId) {
        this.pack.packImgId = packImgId;
    }

    public String getCondition() {
        return this.pack.getCondition();
    }

    public void setCondition(String condition) {
        this.pack.setCondition(condition);
    }

    public void addValidator(String validatorClassName) {
        this.pack.addValidator(validatorClassName);
    }
}

