/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.exception.NativeLibException;
import com.izforge.izpack.api.exception.WrappedNativeLibException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.api.unpacker.IDiscardInterruptable;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.core.os.RegistryHandler;
import com.izforge.izpack.event.NativeInstallerListener;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.helper.SpecHelper;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class RegistryInstallerListener
extends NativeInstallerListener
implements CleanupClient {
    private static final String SPEC_FILE_NAME = "RegistrySpec.xml";
    private static final String REG_KEY = "key";
    private static final String REG_VALUE = "value";
    private static final String REG_ROOT = "root";
    private static final String REG_BASENAME = "name";
    private static final String REG_KEYPATH = "keypath";
    private static final String REG_DWORD = "dword";
    private static final String REG_STRING = "string";
    private static final String REG_MULTI = "multi";
    private static final String REG_BIN = "bin";
    private static final String REG_DATA = "data";
    private static final String REG_OVERRIDE = "override";
    private static final String SAVE_PREVIOUS = "saveprevious";
    private RulesEngine rules;
    private List registryModificationLog;
    private IDiscardInterruptable unpacker;
    private VariableSubstitutor variableSubstitutor;
    private UninstallData uninstallData;

    public RegistryInstallerListener(IDiscardInterruptable unpacker, VariableSubstitutor variableSubstitutor, UninstallData uninstallData) {
        super(true);
        this.variableSubstitutor = variableSubstitutor;
        this.unpacker = unpacker;
        this.uninstallData = uninstallData;
    }

    @Override
    public void beforePacks(AutomatedInstallData installData, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        super.beforePacks(installData, npacks, handler);
        this.rules = installData.getRules();
        this.initializeRegistryHandler(installData);
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        try {
            List<Object> info;
            String uninstallSuffix;
            Housekeeper.getInstance().registerForCleanup(this);
            RegistryHandler rh = RegistryDefaultHandler.getInstance();
            if (rh == null) {
                return;
            }
            IXMLElement uninstallerPack = null;
            this.unpacker.setDiscardInterrupt(true);
            rh.activateLogging();
            if (this.getSpecHelper().getSpec() != null) {
                uninstallerPack = this.getSpecHelper().getPackForName("UninstallStuff");
                this.performPack(uninstallerPack, this.variableSubstitutor);
                for (Pack selectedPack : idata.getSelectedPacks()) {
                    IXMLElement pack = this.getSpecHelper().getPackForName(selectedPack.name);
                    this.performPack(pack, this.variableSubstitutor);
                }
            }
            if ((uninstallSuffix = idata.getVariable("UninstallKeySuffix")) != null) {
                rh.setUninstallName(String.valueOf(rh.getUninstallName()) + " " + uninstallSuffix);
            }
            if (uninstallerPack == null) {
                rh.registerUninstallKey();
            }
            if ((info = rh.getLoggingInfo()) != null) {
                this.uninstallData.addAdditionalData("registryEntries", info);
            }
            this.registryModificationLog = info;
        }
        catch (Exception e) {
            if (e instanceof NativeLibException) {
                throw new WrappedNativeLibException(e);
            }
            throw e;
        }
    }

    @Override
    public void cleanUp() {
        if (AutomatedInstallData.getInstance().isInstallSuccess() || this.registryModificationLog == null || this.registryModificationLog.size() < 1) {
            return;
        }
        RegistryHandler registryHandler = RegistryDefaultHandler.getInstance();
        try {
            if (registryHandler == null) {
                return;
            }
            registryHandler.activateLogging();
            registryHandler.setLoggingInfo(this.registryModificationLog);
            registryHandler.rewind();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void performPack(IXMLElement pack, VariableSubstitutor substitutor) throws Exception {
        List<IXMLElement> regEntries;
        if (pack == null) {
            return;
        }
        String packcondition = pack.getAttribute("condition");
        if (packcondition != null) {
            Debug.trace("condition " + packcondition + " found for pack of registry entries.");
            if (!this.rules.isConditionTrue(packcondition)) {
                Debug.trace("not fulfilled.");
                return;
            }
        }
        if ((regEntries = pack.getChildren()) == null) {
            return;
        }
        for (IXMLElement regEntry : regEntries) {
            String type;
            String condition = regEntry.getAttribute("condition");
            if (condition != null) {
                Debug.trace("condition " + condition + " found for registry entry.");
                if (!this.rules.isConditionTrue(condition)) {
                    Debug.trace("not fulfilled.");
                    continue;
                }
            }
            if ((type = regEntry.getName()).equalsIgnoreCase(REG_KEY)) {
                this.performKeySetting(regEntry, substitutor);
                continue;
            }
            if (type.equalsIgnoreCase(REG_VALUE)) {
                this.performValueSetting(regEntry, substitutor);
                continue;
            }
            this.getSpecHelper().parseError(regEntry, "Non-valid type of entry; only 'key' and 'value' are allowed.");
        }
    }

    private void performValueSetting(IXMLElement regEntry, VariableSubstitutor substitutor) throws Exception {
        SpecHelper specHelper = this.getSpecHelper();
        String name = specHelper.getRequiredAttribute(regEntry, REG_BASENAME);
        name = substitutor.substitute(name);
        String keypath = specHelper.getRequiredAttribute(regEntry, REG_KEYPATH);
        keypath = substitutor.substitute(keypath);
        String root = specHelper.getRequiredAttribute(regEntry, REG_ROOT);
        int rootId = this.resolveRoot(regEntry, root, substitutor);
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.setRoot(rootId);
        String override = regEntry.getAttribute(REG_OVERRIDE, "true");
        if (!"true".equalsIgnoreCase(override) && rh.getValue(keypath, name, null) != null) {
            return;
        }
        rh.setLogPrevSetValueFlag("true".equalsIgnoreCase(regEntry.getAttribute(SAVE_PREVIOUS, "true")));
        String value = regEntry.getAttribute(REG_DWORD);
        if (value != null) {
            value = substitutor.substitute(value);
            rh.setValue(keypath, name, Long.parseLong(value));
            return;
        }
        value = regEntry.getAttribute(REG_STRING);
        if (value != null) {
            value = substitutor.substitute(value);
            rh.setValue(keypath, name, value);
            return;
        }
        List<IXMLElement> values = regEntry.getChildrenNamed(REG_MULTI);
        if (values != null && !values.isEmpty()) {
            Iterator<IXMLElement> multiIter = values.iterator();
            String[] multiString = new String[values.size()];
            int i = 0;
            while (multiIter.hasNext()) {
                IXMLElement element = multiIter.next();
                multiString[i] = specHelper.getRequiredAttribute(element, REG_DATA);
                multiString[i] = substitutor.substitute(multiString[i]);
                ++i;
            }
            rh.setValue(keypath, name, multiString);
            return;
        }
        values = regEntry.getChildrenNamed(REG_BIN);
        if (values != null && !values.isEmpty()) {
            Iterator<IXMLElement> multiIter = values.iterator();
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (multiIter.hasNext()) {
                IXMLElement element = multiIter.next();
                String tmp = specHelper.getRequiredAttribute(element, REG_DATA);
                buf.append(tmp);
                if (!tmp.endsWith(",") && multiIter.hasNext()) {
                    buf.append(",");
                }
                ++i;
            }
            byte[] bytes = this.extractBytes(regEntry, substitutor.substitute(buf.toString()));
            rh.setValue(keypath, name, bytes);
            return;
        }
        specHelper.parseError(regEntry, "No data found.");
    }

    private byte[] extractBytes(IXMLElement element, String byteString) throws Exception {
        StringTokenizer st = new StringTokenizer(byteString, ",");
        byte[] retval = new byte[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            byte value = 0;
            String token = st.nextToken().trim();
            try {
                int tval = Integer.parseInt(token, 16);
                if (tval < 0 || tval > 255) {
                    throw new NumberFormatException("Value out of range.");
                }
                if (tval > 127) {
                    tval -= 256;
                }
                value = (byte)tval;
            }
            catch (NumberFormatException nfe) {
                this.getSpecHelper().parseError(element, "Bad entry for REG_BINARY; a byte should be written as 2 digit hexvalue followed by a ','.");
            }
            retval[i++] = value;
        }
        return retval;
    }

    private void performKeySetting(IXMLElement regEntry, VariableSubstitutor substitutor) throws Exception {
        String keypath = this.getSpecHelper().getRequiredAttribute(regEntry, REG_KEYPATH);
        keypath = substitutor.substitute(keypath);
        String root = this.getSpecHelper().getRequiredAttribute(regEntry, REG_ROOT);
        int rootId = this.resolveRoot(regEntry, root, substitutor);
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.setRoot(rootId);
        if (!rh.keyExist(keypath)) {
            rh.createKey(keypath);
        }
    }

    private int resolveRoot(IXMLElement regEntry, String root, VariableSubstitutor substitutor) throws Exception {
        String root1 = substitutor.substitute(root);
        Integer tmp = RegistryHandler.ROOT_KEY_MAP.get(root1);
        if (tmp != null) {
            return tmp;
        }
        this.getSpecHelper().parseError(regEntry, "Unknown value (" + root1 + ")for registry root.");
        return 0;
    }

    private void initializeRegistryHandler(AutomatedInstallData idata) throws Exception {
        RegistryHandler rh = RegistryDefaultHandler.getInstance();
        if (rh == null) {
            return;
        }
        rh.verify(idata);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME);
    }
}

