/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.util.helper.SpecHelper;
import java.io.File;
import java.util.ArrayList;

public class SimpleInstallerListener
implements InstallerListener {
    private static ArrayList<SimpleInstallerListener> progressBarCaller = new ArrayList();
    protected static final String LANG_FILE_NAME = "CustomActionsLang.xml";
    protected static LocaleDatabase langpack = null;
    protected static boolean doInformProgressBar = false;
    private AutomatedInstallData installdata = null;
    private SpecHelper specHelper = null;

    public SimpleInstallerListener() {
        this(false);
    }

    public SimpleInstallerListener(boolean useSpecHelper) {
        if (useSpecHelper) {
            this.setSpecHelper(new SpecHelper());
        }
    }

    @Override
    public void afterFile(File file, PackFile pf) throws Exception {
    }

    @Override
    public void afterDir(File dir, PackFile pf) throws Exception {
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
    }

    @Override
    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        if (this.installdata == null) {
            this.installdata = idata;
        }
        if (this.installdata != null && langpack == null) {
            try {
                String resource = "CustomActionsLang.xml_" + this.installdata.getLocaleISO3();
                langpack = new LocaleDatabase(ResourceManager.getInstance().getInputStream(resource));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
    }

    @Override
    public boolean isFileListener() {
        return false;
    }

    @Override
    public void beforeFile(File file, PackFile pf) throws Exception {
    }

    @Override
    public void beforeDir(File dir, PackFile pf) throws Exception {
    }

    @Override
    public void afterInstallerInitialization(AutomatedInstallData data) {
        this.installdata = data;
    }

    public SpecHelper getSpecHelper() {
        return this.specHelper;
    }

    public void setSpecHelper(SpecHelper helper) {
        this.specHelper = helper;
    }

    public AutomatedInstallData getInstalldata() {
        return this.installdata;
    }

    public void setInstalldata(AutomatedInstallData data) {
        this.installdata = data;
    }

    public static int getProgressBarCallerCount() {
        return progressBarCaller.size();
    }

    protected int getProgressBarCallerId() {
        int i = 0;
        while (i < progressBarCaller.size()) {
            if (progressBarCaller.get(i) == this) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    protected void setProgressBarCaller() {
        progressBarCaller.add(this);
    }

    protected boolean informProgressBar() {
        return doInformProgressBar;
    }

    protected String getMsg(String id) {
        String retval = id;
        if (langpack != null) {
            retval = langpack.getString(id);
        }
        if (retval.equals(id) && this.getInstalldata() != null) {
            retval = this.getInstalldata().getLangpack().getString(id);
        }
        return retval;
    }
}

