/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.helper.SummaryProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SummaryLoggerInstallerListener
extends SimpleInstallerListener {
    private VariableSubstitutor variableSubstitutor;

    public SummaryLoggerInstallerListener(VariableSubstitutor variableSubstitutor) {
        super(false);
        this.variableSubstitutor = variableSubstitutor;
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        if (!this.getInstalldata().isInstallSuccess()) {
            return;
        }
        if (this.getInstalldata().getPanels() == null || this.getInstalldata().getPanels().size() < 1) {
            return;
        }
        String path = this.getInstalldata().getInfo().getSummaryLogFilePath();
        if (path == null) {
            return;
        }
        File parent = new File(path = IoHelper.translatePath(path, this.variableSubstitutor)).getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        String summary = SummaryProcessor.getSummary(this.getInstalldata());
        FileOutputStream out = new FileOutputStream(path);
        ((OutputStream)out).write(summary.getBytes("utf-8"));
        ((OutputStream)out).close();
    }
}

