/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.IzPanelConstraints;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.gui.MultiLineLabel;
import com.izforge.izpack.gui.log.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;

public class IzPanelLayout
implements LayoutManager,
LayoutManager2,
LayoutConstants {
    private ArrayList<ArrayList<IzPanelConstraints>> components = new ArrayList();
    private int currentYPos = 0;
    private int currentXPos = -1;
    private Dimension prefLayoutDim;
    private Dimension oldParentSize;
    private Insets oldParentInsets;
    private int columnFillOutRule;
    private double[] overallYStretch = new double[]{-1.0, 0.0};
    protected static int[] DEFAULT_Y_GAPS;
    protected static int[] DEFAULT_X_GAPS;
    protected static int[] DEFAULT_X_ALIGNMENT;
    protected static int[] DEFAULT_Y_ALIGNMENT;
    private static IzPanelConstraints[] DEFAULT_CONSTRAINTS;
    private static int ANCHOR;
    private static int X_STRETCH_TYPE;
    private static int Y_STRETCH_TYPE;
    private static double FULL_LINE_STRETCH_DEFAULT;
    private static double FULL_COLUMN_STRETCH_DEFAULT;
    private static int DEFAULT_TEXTFIELD_LENGTH;
    private static final int[][] GAP_INTERMEDIAER_LOOKUP;

    static {
        int[] nArray = new int[20];
        nArray[0] = -1;
        nArray[2] = 5;
        nArray[3] = 5;
        nArray[4] = 10;
        nArray[5] = 5;
        nArray[6] = 5;
        nArray[7] = 5;
        nArray[8] = 5;
        nArray[9] = 5;
        nArray[10] = 5;
        nArray[11] = 5;
        nArray[12] = 5;
        nArray[13] = 5;
        nArray[14] = 15;
        nArray[15] = 12;
        nArray[16] = 9;
        nArray[17] = 6;
        nArray[18] = 3;
        DEFAULT_Y_GAPS = nArray;
        int[] nArray2 = new int[19];
        nArray2[0] = -1;
        nArray2[6] = 10;
        nArray2[7] = 10;
        nArray2[8] = 10;
        nArray2[9] = 10;
        nArray2[10] = 10;
        nArray2[11] = 10;
        nArray2[12] = 10;
        nArray2[13] = 15;
        nArray2[14] = 12;
        nArray2[15] = 9;
        nArray2[16] = 6;
        nArray2[17] = 3;
        DEFAULT_X_GAPS = nArray2;
        DEFAULT_X_ALIGNMENT = new int[]{2, 2, 2, 2};
        DEFAULT_Y_ALIGNMENT = new int[4];
        DEFAULT_CONSTRAINTS = new IzPanelConstraints[]{new IzPanelConstraints(-1, -1, -1, -2, 1, 1, -19, -19, 0.0, 0.0), new IzPanelConstraints(-2, -2, -1, -2, 1, 1, -19, -19, 0.0, 0.0), new IzPanelConstraints(-3, -3, -1, -2, 1, 1, -19, -19, 0.0, 0.0), new IzPanelConstraints(-1, -1, 0, -1, 127, 127, -19, -19, -1.0, 0.0), new IzPanelConstraints(-1, -1, 0, -1, 127, 127, -19, -19, -1.0, -2.0), new IzPanelConstraints(-1, -1, -1, -2, 1, 1, 0, 0, 0.0, 0.0), new IzPanelConstraints(-1, -1, 0, -1, 1, 1, 0, 0, 0.0, 0.0), new IzPanelConstraints(-3, -3, 0, -1, 127, 127, -19, -19, -1.0, 0.0)};
        ANCHOR = 0;
        X_STRETCH_TYPE = 1;
        Y_STRETCH_TYPE = 1;
        FULL_LINE_STRETCH_DEFAULT = 1.0;
        FULL_COLUMN_STRETCH_DEFAULT = 1.0;
        DEFAULT_TEXTFIELD_LENGTH = 12;
        GAP_INTERMEDIAER_LOOKUP = new int[][]{{-1, -5, -6, -1, -6, -1, -1}, {-7, -2, -10, -7, -10, -2, -2}, {-8, -9, -3, -8, -3, -3, -3}, {-1, -5, -6, -1, -6, -1, -1}, {-8, -9, -3, -8, -3, -3, -3}, {-13, -13, -13, -13, -13, -13, -13, -13}, {-13, -13, -13, -13, -13, -13, -13, -13}, {-13, -13, -13, -13, -13, -13, -13, -13}};
    }

    public IzPanelLayout() {
        this(0);
    }

    public IzPanelLayout(int colFillOutRule) {
        this.columnFillOutRule = colFillOutRule;
    }

    private static int getYGap(IzPanelConstraints curConst, IzPanelConstraints nextYConst) {
        Class<FillerComponent> nextClass = nextYConst != null ? nextYConst.component.getClass() : FillerComponent.class;
        int interId = GAP_INTERMEDIAER_LOOKUP[IzPanelLayout.getIntermediarId(curConst.component.getClass(), null)][IzPanelLayout.getIntermediarId(nextClass, null)];
        if (interId < 0) {
            interId = -interId;
        }
        return DEFAULT_Y_GAPS[interId];
    }

    private static int getXGap(IzPanelConstraints curConst, IzPanelConstraints nextXConst) {
        Class<FillerComponent> nextClass = nextXConst != null ? nextXConst.component.getClass() : FillerComponent.class;
        int interId = GAP_INTERMEDIAER_LOOKUP[IzPanelLayout.getIntermediarId(curConst.component.getClass(), null)][IzPanelLayout.getIntermediarId(nextClass, null)];
        if (interId < 0) {
            interId = -interId;
        }
        return DEFAULT_X_GAPS[interId];
    }

    private static int getIntermediarId(Class clazz, Component comp) {
        if (comp != null) {
            if (MultiLineLabel.class.isAssignableFrom(clazz) || LabelFactory.FullLineLabel.class.isAssignableFrom(clazz)) {
                return 3;
            }
            if (JCheckBox.class.isAssignableFrom(clazz) || JRadioButton.class.isAssignableFrom(clazz)) {
                return 7;
            }
            if (FillerComponent.class.isAssignableFrom(clazz) || Box.Filler.class.isAssignableFrom(clazz)) {
                Dimension size = comp.getPreferredSize();
                if (size.height >= Short.MAX_VALUE || size.height <= 0) {
                    size.height = 0;
                    comp.setSize(size);
                    return 5;
                }
                if (size.width >= Short.MAX_VALUE || size.width <= 0) {
                    size.width = 0;
                    comp.setSize(size);
                    return 6;
                }
            }
        }
        if (JScrollPane.class.isAssignableFrom(clazz)) {
            return 4;
        }
        if (JLabel.class.isAssignableFrom(clazz)) {
            return 0;
        }
        if (JTextComponent.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (FillerComponent.class.isAssignableFrom(clazz)) {
            return 5;
        }
        if (Box.Filler.class.isAssignableFrom(clazz)) {
            return 5;
        }
        return 2;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.determineSize();
    }

    private Dimension determineSize() {
        if (this.prefLayoutDim == null) {
            int width = this.minimumAllColumnsWidth();
            int height = this.minimumOverallHeight();
            this.prefLayoutDim = new Dimension(width, height);
        }
        return (Dimension)this.prefLayoutDim.clone();
    }

    private int rows() {
        int maxRows = 0;
        for (ArrayList<IzPanelConstraints> component : this.components) {
            int curRows = component.size();
            if (curRows <= maxRows) continue;
            maxRows = curRows;
        }
        return maxRows;
    }

    private int columns() {
        return this.components.size();
    }

    private int minimumOverallHeight() {
        int height = 0;
        int i = 0;
        while (i < this.rows()) {
            height += this.rowHeight(i);
            ++i;
        }
        return height;
    }

    private int rowHeight(int row) {
        int height = 0;
        int i = 0;
        while (i < this.components.size()) {
            int curHeight = this.getCellSize((int)i, (int)row, null).height;
            if (curHeight > height) {
                height = curHeight;
            }
            ++i;
        }
        return height;
    }

    private int rowHeight(int row, int minOverallHeight, int maxOverallHeight) {
        int height = 0;
        double[] yStretch = this.getOverallYStretch();
        if (yStretch[0] <= 0.0) {
            return this.rowHeight(row);
        }
        double maxStretch = 0.0;
        double[] stretchParts = new double[this.components.size()];
        int i = 0;
        while (i < this.components.size()) {
            int curHeight;
            double stretch;
            IzPanelConstraints constraints = this.getConstraints(i, row);
            stretchParts[i] = stretch = constraints.getYStretch();
            if (stretch > maxStretch) {
                maxStretch = stretch;
            }
            if ((curHeight = this.getCellSize((int)i, (int)row, (IzPanelConstraints)constraints).height) > height) {
                height = curHeight;
            }
            ++i;
        }
        if (maxOverallHeight <= minOverallHeight) {
            return height;
        }
        int pixels = (int)((double)maxOverallHeight - yStretch[1] - (double)minOverallHeight);
        int stretchPart = (int)((double)pixels * maxStretch);
        if (stretchPart > 0) {
            int i2 = 0;
            while (i2 < this.components.size()) {
                if (!(stretchParts[i2] < 1.0E-8)) {
                    IzPanelConstraints constraints = this.getConstraints(i2, row);
                    Dimension size = constraints.component.getPreferredSize();
                    size.height = (double)size.height + (double)stretchPart * stretchParts[i2] < (double)height ? (int)((double)height + (double)stretchPart * stretchParts[i2]) : height + stretchPart;
                    if (constraints.component instanceof JScrollPane && ((JScrollPane)constraints.component).getViewport().getView() instanceof JTextArea && ((JTextArea)((JScrollPane)constraints.component).getViewport().getView()).getLineWrap()) {
                        size.width = 1000;
                    }
                    constraints.component.setPreferredSize(size);
                }
                ++i2;
            }
            height += stretchPart;
        }
        return height;
    }

    private double[] getOverallYStretch() {
        if (this.overallYStretch[0] >= 0.0) {
            return this.overallYStretch;
        }
        this.overallYStretch[0] = 0.0;
        int row = 0;
        while (row < this.rows()) {
            double maxStretch = 0.0;
            double maxGap = 0.0;
            int i = 0;
            while (i < this.components.size()) {
                double curYGap;
                double curStretch;
                IzPanelConstraints constraints = this.getConstraints(i, row);
                this.resolveDefaultSettings(i, row);
                if (constraints.getYStretch() == -2.0) {
                    constraints.setYStretch(IzPanelLayout.getFullColumnStretch());
                }
                if ((curStretch = constraints.getYStretch()) > maxStretch) {
                    maxStretch = curStretch;
                }
                if ((curYGap = (double)constraints.getYGap()) > maxGap) {
                    maxGap = curYGap;
                }
                ++i;
            }
            this.overallYStretch[0] = this.overallYStretch[0] + maxStretch;
            this.overallYStretch[1] = this.overallYStretch[1] + maxGap;
            ++row;
        }
        if (this.overallYStretch[0] > 0.0) {
            switch (IzPanelLayout.getYStretchType()) {
                case 1: {
                    break;
                }
                case 2: {
                    this.overallYStretch[0] = 1.0;
                    break;
                }
                default: {
                    this.overallYStretch[0] = 0.0;
                }
            }
        }
        return this.overallYStretch;
    }

    private Dimension getCellSize(int column, int row, IzPanelConstraints constraints) {
        Dimension retval = new Dimension();
        try {
            if (constraints == null) {
                constraints = this.getConstraints(column, row);
            }
            if (constraints != null) {
                Component component = constraints.component;
                Dimension dim = component.getPreferredSize();
                Dimension dim2 = component.getMinimumSize();
                retval.height = dim.height > dim2.height ? dim.height : dim2.height;
                int n = retval.width = dim.width > dim2.width ? dim.width : dim2.width;
                if (component instanceof JScrollPane) {
                    retval.height = dim2.height;
                    retval.width = dim2.width;
                }
                if (this.needsReEvaluation(component)) {
                    retval.width = 0;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retval;
    }

    private int minimumColumnWidth(int column) {
        int maxWidth = 0;
        Dimension[] cs = new Dimension[this.rows()];
        int i = 0;
        while (i < this.rows()) {
            IzPanelConstraints constraints = this.getConstraints(column, i);
            cs[i] = this.getCellSize(column, i, constraints);
            if (constraints.getXWeight() <= 1 && maxWidth < cs[i].width) {
                maxWidth = cs[i].width;
            }
            ++i;
        }
        if (maxWidth == 0) {
            i = 0;
            while (i < this.rows()) {
                if (maxWidth < cs[i].width) {
                    maxWidth = cs[i].width;
                }
                ++i;
            }
        }
        return maxWidth;
    }

    private int minimumAllColumnsWidth() {
        int width = 0;
        int i = 0;
        while (i < this.components.size()) {
            width += this.minimumColumnWidth(i);
            ++i;
        }
        return width;
    }

    /*
     * Unable to fully structure code
     */
    private IzPanelConstraints getConstraints(int col, int row) {
        if (col >= this.columns() || row >= this.rows()) {
            return null;
        }
        constraints = this.components.get(col);
        if (constraints != null) {
            try {
                return constraints.get(row);
            }
            catch (Throwable var4_4) {
                curRow = constraints.size();
                ** while (row >= curRow)
            }
lbl-1000:
            // 1 sources

            {
                currentConst = IzPanelLayout.getDefaultConstraint(5);
                currentConst.setXPos(col);
                currentConst.setYPos(curRow);
                currentConst.component = new FillerComponent();
                try {
                    constraints.add(row, currentConst);
                }
                catch (Throwable t) {
                    return null;
                }
                ++curRow;
                continue;
            }
lbl21:
            // 1 sources

            return this.getConstraints(col, row);
        }
        return null;
    }

    private int getAdaptedXPos(int xpos, int curWidth, Dimension curDim, IzPanelConstraints currentConst) {
        int adaptedXPos = xpos;
        if ((this.columnFillOutRule & 1) > 0) {
            return adaptedXPos;
        }
        switch (currentConst.getXCellAlignment()) {
            case 2: {
                break;
            }
            case 4: {
                adaptedXPos += curWidth - curDim.width;
                break;
            }
            default: {
                adaptedXPos += (curWidth - curDim.width) / 2;
            }
        }
        return adaptedXPos;
    }

    private int getAdaptedYPos(int ypos, int curHeight, Dimension curDim, IzPanelConstraints currentConst) {
        int adaptedYPos = ypos;
        if ((this.columnFillOutRule & 2) > 0) {
            return adaptedYPos;
        }
        int height = curDim.height;
        switch (currentConst.getYCellAlignment()) {
            case 1: {
                break;
            }
            case 3: {
                adaptedYPos += curHeight - height;
                break;
            }
            default: {
                adaptedYPos += (curHeight - height) / 2;
            }
        }
        if (adaptedYPos < ypos) {
            return ypos;
        }
        return adaptedYPos;
    }

    private void resolveDefaultSettings(int col, int row) {
        IzPanelConstraints currentConst = this.getConstraints(col, row);
        IzPanelConstraints nextYConst = this.getConstraints(col, row + 1);
        IzPanelConstraints nextXConst = this.getConstraints(col + 1, row);
        if (currentConst == null) {
            return;
        }
        int gap = currentConst.getYGap();
        if (gap == -19) {
            currentConst.setYGap(IzPanelLayout.getYGap(currentConst, nextYConst));
        } else if (gap < 0) {
            currentConst.setYGap(DEFAULT_Y_GAPS[-gap]);
        }
        gap = currentConst.getXGap();
        if (gap == -19) {
            currentConst.setXGap(IzPanelLayout.getXGap(currentConst, nextXConst));
        } else if (gap < 0) {
            currentConst.setXGap(DEFAULT_X_GAPS[-gap]);
        }
        if (currentConst.getXCellAlignment() < 0) {
            currentConst.setXCellAlignment(DEFAULT_X_ALIGNMENT[-currentConst.getXCellAlignment()]);
        }
        if (currentConst.getYCellAlignment() < 0) {
            currentConst.setYCellAlignment(DEFAULT_Y_ALIGNMENT[-currentConst.getYCellAlignment()]);
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!this.needNewLayout(parent)) {
            this.fastLayoutContainer(parent);
            return;
        }
        this.prefLayoutDim = null;
        this.preferredLayoutSize(parent);
        Dimension realSizeDim = parent.getSize();
        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer parent size: {0}", new String[]{parent.getSize().toString()}, "LayoutTrace", null);
        Insets insets = parent.getInsets();
        int rowHeight = 0;
        int onceAgain = 0;
        int[] generellOffset = new int[2];
        int maxWidth = 0;
        int overallHeight = 0;
        int anchorNeedsReEval = 0;
        Rectangle curRect = new Rectangle();
        int minOverallHeight = this.minimumOverallHeight();
        int maxOverallHeight = realSizeDim.height - insets.top - insets.bottom;
        while (anchorNeedsReEval < 2) {
            int ypos = insets.top;
            int row = 0;
            int minWidth = 65535;
            int minHeight = 65535;
            maxWidth = 0;
            overallHeight = 0;
            while (row < this.rows()) {
                int outerRowHeight = 0;
                int xpos = insets.left;
                int col = 0;
                IzPanelConstraints[] colConstraints = new IzPanelConstraints[this.columns()];
                int usedWidth = 0;
                while (col < this.columns()) {
                    int curMax;
                    IzPanelConstraints currentConst;
                    if (col == 0) {
                        rowHeight = this.rowHeight(row, minOverallHeight, maxOverallHeight);
                    }
                    colConstraints[col] = currentConst = this.getConstraints(col, row);
                    Component currentComp = currentConst.component;
                    Dimension curDim = currentComp.getPreferredSize();
                    int curWidth = this.minimumColumnWidth(col);
                    ++col;
                    if (currentConst.getXWeight() > 1) {
                        int weight = currentConst.getXWeight();
                        while (weight > 1 && col < this.columns()) {
                            colConstraints[col] = this.getConstraints(col, row);
                            if (!(colConstraints[col].component instanceof FillerComponent)) break;
                            curWidth += this.minimumColumnWidth(col);
                            ++col;
                            --weight;
                        }
                    }
                    int adaptedXPos = this.getAdaptedXPos(xpos, curWidth, curDim, currentConst);
                    int adaptedYPos = this.getAdaptedYPos(ypos, rowHeight, curDim, currentConst);
                    int useWidth = curDim.width;
                    int useHeight = curDim.height;
                    if ((this.columnFillOutRule & 1) > 0) {
                        useWidth = curWidth;
                    }
                    if ((this.columnFillOutRule & 2) > 0) {
                        useHeight = rowHeight;
                    }
                    if (curWidth < useWidth) {
                        useWidth = curWidth;
                    }
                    currentComp.setBounds(adaptedXPos + generellOffset[0], adaptedYPos + generellOffset[1], useWidth, useHeight);
                    currentComp.getBounds(curRect);
                    if (curRect.height > 100) {
                        curRect.height = useHeight;
                    }
                    if (!(currentComp instanceof FillerComponent)) {
                        if (curRect.x < minWidth) {
                            minWidth = curRect.x;
                        }
                        if (curRect.y < minHeight) {
                            minHeight = curRect.y;
                        }
                    }
                    if ((curMax = (int)curRect.getMaxX()) - minWidth > maxWidth) {
                        maxWidth = curMax - minWidth;
                    }
                    curMax = (int)curRect.getMaxY();
                    currentConst.setBounds(curRect);
                    if (curMax - minHeight > overallHeight) {
                        overallHeight = curMax - minHeight;
                    }
                    xpos += curWidth + currentConst.getXGap();
                    usedWidth += curWidth;
                    if (outerRowHeight >= rowHeight + currentConst.getYGap()) continue;
                    outerRowHeight = rowHeight + currentConst.getYGap();
                }
                double rowStretch = 0.0;
                int i = 0;
                while (i < colConstraints.length) {
                    if (colConstraints[i].getXStretch() == -1.0) {
                        colConstraints[i].setXStretch(IzPanelLayout.getFullLineStretch());
                    }
                    rowStretch += colConstraints[i].getXStretch();
                    ++i;
                }
                if (rowStretch > 0.0) {
                    switch (IzPanelLayout.getXStretchType()) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            rowStretch = 1.0;
                            break;
                        }
                        default: {
                            rowStretch = 0.0;
                        }
                    }
                }
                if (realSizeDim.width - insets.right != xpos && rowStretch > 0.0) {
                    int pixel = realSizeDim.width - insets.right - xpos;
                    int offset = 0;
                    int oldOnceAgain = onceAgain;
                    i = 0;
                    while (i < colConstraints.length) {
                        int curMax;
                        int curPixel = (int)(colConstraints[i].getXStretch() / rowStretch * (double)pixel);
                        Rectangle curBounds = colConstraints[i].component.getBounds();
                        int curWidth = this.minimumColumnWidth(i);
                        if (curBounds.width < curWidth) {
                            curBounds.width = curWidth;
                        }
                        int newWidth = curPixel + curBounds.width;
                        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer resize bounds for {2}|{3} old width {0} new width {1}", new String[]{Integer.toString(curBounds.width), Integer.toString(newWidth), Integer.toString(row), Integer.toString(i)}, "LayoutTrace", null);
                        colConstraints[i].component.setBounds(curBounds.x + offset, curBounds.y, newWidth, curBounds.height);
                        colConstraints[i].component.getBounds(curRect);
                        if (curRect.x > 0 && curRect.x < minWidth) {
                            minWidth = curRect.x;
                        }
                        if (curRect.y > 0 && curRect.y < minHeight) {
                            minHeight = curRect.y;
                        }
                        if ((curMax = (int)curRect.getMaxX()) - minWidth > maxWidth) {
                            maxWidth = curMax - minWidth;
                        }
                        curMax = (int)curRect.getMaxY();
                        colConstraints[i].setBounds(curRect);
                        if (curMax - minHeight > overallHeight) {
                            overallHeight = curMax - minHeight;
                        }
                        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer resize bounds for {2}|{3} ({0}): {1}", new String[]{colConstraints[i].component.getClass().getName(), curRect.toString(), Integer.toString(row), Integer.toString(i)}, "LayoutTrace", null);
                        Log.getInstance().addDebugMessage("IzPanelLayout.layoutContainer resize bounds for {2}|{3}: maxWidth = {0} maxHeight = {1}", new String[]{Integer.toString(maxWidth), Integer.toString(overallHeight), Integer.toString(row), Integer.toString(i)}, "LayoutTrace", null);
                        offset += curPixel;
                        if (this.needsReEvaluation(colConstraints[i].component) && oldOnceAgain == onceAgain) {
                            ++onceAgain;
                        }
                        ++i;
                    }
                }
                if (onceAgain == 1) continue;
                onceAgain = 0;
                ypos += outerRowHeight;
                ++row;
            }
            anchorNeedsReEval += this.resolveGenerellOffsets(generellOffset, realSizeDim, insets, maxWidth, overallHeight);
        }
    }

    private void fastLayoutContainer(Container parent) {
        int row = 0;
        while (row < this.rows()) {
            int col = 0;
            while (col < this.columns()) {
                IzPanelConstraints currentConst = this.getConstraints(col, row);
                if (currentConst != null) {
                    Log.getInstance().addDebugMessage("IzPanelLayout.fastLayoutContainer bounds: {0}", new String[]{currentConst.getBounds().toString()}, "LayoutTrace", null);
                    currentConst.component.setBounds(currentConst.getBounds());
                }
                ++col;
            }
            ++row;
        }
    }

    private boolean needNewLayout(Container parent) {
        Dimension ops = this.oldParentSize;
        Insets opi = this.oldParentInsets;
        this.oldParentSize = parent.getSize();
        this.oldParentInsets = parent.getInsets();
        if (opi == null) {
            return true;
        }
        return !ops.equals(parent.getSize()) || !opi.equals(parent.getInsets());
    }

    private int resolveGenerellOffsets(int[] generellOffset, Dimension realSizeDim, Insets insets, int maxWidth, int overallHeight) {
        int retval = 1;
        switch (IzPanelLayout.getAnchor()) {
            case 0: {
                generellOffset[0] = (realSizeDim.width - insets.left - insets.right - maxWidth) / 2;
                generellOffset[1] = (realSizeDim.height - insets.top - insets.bottom - overallHeight) / 2;
                break;
            }
            case 7: {
                generellOffset[0] = 0;
                generellOffset[1] = (realSizeDim.height - insets.top - insets.bottom - overallHeight) / 2;
                break;
            }
            case 3: {
                generellOffset[0] = realSizeDim.width - insets.left - insets.right - maxWidth;
                generellOffset[1] = (realSizeDim.height - insets.top - insets.bottom - overallHeight) / 2;
                break;
            }
            case 1: {
                generellOffset[0] = (realSizeDim.width - insets.left - insets.right - maxWidth) / 2;
                generellOffset[1] = 0;
                break;
            }
            case 5: {
                generellOffset[0] = (realSizeDim.width - insets.left - insets.right - maxWidth) / 2;
                generellOffset[1] = realSizeDim.height - insets.top - insets.bottom - overallHeight;
                break;
            }
            case 8: {
                generellOffset[0] = 0;
                generellOffset[1] = 0;
                retval = 2;
                break;
            }
            case 2: {
                generellOffset[0] = realSizeDim.width - insets.left - insets.right - maxWidth;
                generellOffset[1] = 0;
                break;
            }
            case 6: {
                generellOffset[0] = 0;
                generellOffset[1] = realSizeDim.height - insets.top - insets.bottom - overallHeight;
                break;
            }
            case 4: {
                generellOffset[0] = realSizeDim.width - insets.left - insets.right - maxWidth;
                generellOffset[1] = realSizeDim.height - insets.top - insets.bottom - overallHeight;
            }
        }
        if (generellOffset[0] < 0) {
            generellOffset[0] = 0;
        }
        if (generellOffset[1] < 0) {
            generellOffset[1] = 0;
        }
        return retval;
    }

    private boolean needsReEvaluation(Component comp) {
        return comp instanceof MultiLineLabel;
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this.minimumLayoutSize(target);
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        int perfCol;
        IzPanelConstraints cc;
        if (comp == null) {
            throw new NullPointerException("component has to be not null");
        }
        if (!(constraints instanceof IzPanelConstraints)) {
            cc = comp instanceof FillerComponent && ((FillerComponent)comp).getConstraints() != null ? (IzPanelConstraints)((FillerComponent)comp).getConstraints().clone() : (IzPanelConstraints)DEFAULT_CONSTRAINTS[IzPanelLayout.getIntermediarId(comp.getClass(), comp)].clone();
            if ("nextLine".equals(constraints)) {
                cc.setXPos(0);
                cc.setYPos(-1);
            }
        } else {
            cc = (IzPanelConstraints)((IzPanelConstraints)constraints).clone();
        }
        cc.component = comp;
        int yPos = cc.getYPos();
        if (yPos == -1) {
            yPos = this.currentYPos + 1;
        }
        if (yPos == -2) {
            yPos = this.currentYPos;
        }
        cc.setYPos(yPos);
        int xPos = cc.getXPos();
        if (xPos == -1) {
            xPos = this.currentXPos + 1;
        }
        if (xPos == -2) {
            xPos = this.currentXPos;
        }
        cc.setXPos(xPos);
        int n = perfCol = cc.getXWeight() < 127 ? cc.getXWeight() : 1;
        if (this.components.size() < cc.getXPos() + perfCol) {
            int i = this.components.size() - 1;
            while (i < cc.getXPos() + perfCol - 1) {
                this.components.add(new ArrayList());
                ++i;
            }
        }
        IzPanelConstraints curConst = cc;
        int j = 0;
        while (j < perfCol) {
            ArrayList<IzPanelConstraints> xComp = this.components.get(xPos);
            if (xComp.size() < yPos) {
                int i = xComp.size() - 1;
                while (i < yPos - 1) {
                    IzPanelConstraints dc = IzPanelLayout.getDefaultConstraint(5);
                    dc.component = new FillerComponent();
                    xComp.add(dc);
                    ++i;
                }
            }
            xComp.add(yPos, curConst);
            if (j < perfCol - 1) {
                curConst = IzPanelLayout.getDefaultConstraint(5);
                curConst.component = new FillerComponent();
                ++xPos;
            }
            ++j;
        }
        int xcsize = this.components.get(xPos).size() - 1;
        if (this.currentYPos < xcsize) {
            this.currentYPos = xcsize;
        }
        this.currentXPos = xPos;
    }

    public static Component createHorizontalStrut(int width) {
        return new FillerComponent(new Dimension(width, 0));
    }

    public static Component createVerticalStrut(int height) {
        return new FillerComponent(new Dimension(0, height));
    }

    public static Component createParagraphGap() {
        return IzPanelLayout.createGap(-4, 1);
    }

    public static Component createVerticalFiller(int fillerNumber) {
        return IzPanelLayout.createGap(-13 - fillerNumber, 1);
    }

    public static Component createHorizontalFiller(int fillerNumber) {
        return IzPanelLayout.createGap(-13 - fillerNumber, 0);
    }

    public static Component createGap(int gapType, int direction) {
        if (direction == 0) {
            return new FillerComponent(new Dimension(0, 0), new IzPanelConstraints(-3, -3, -1, -2, 1, 1, gapType, 0, 0.0, 0.0));
        }
        return new FillerComponent(new Dimension(0, 0), new IzPanelConstraints(-3, -3, 0, -1, 10, 10, 0, gapType, 1.0, 0.0));
    }

    public static IzPanelConstraints getDefaultConstraint(int type) {
        return (IzPanelConstraints)DEFAULT_CONSTRAINTS[type].clone();
    }

    public static int getAnchor() {
        return ANCHOR;
    }

    public static void setAnchor(int anchor) {
        ANCHOR = anchor;
    }

    public static int getXStretchType() {
        return X_STRETCH_TYPE;
    }

    public static void setXStretchType(int x_stretch) {
        X_STRETCH_TYPE = x_stretch;
    }

    public static int getYStretchType() {
        return Y_STRETCH_TYPE;
    }

    public static void setYStretchType(int y_stretch) {
        Y_STRETCH_TYPE = y_stretch;
    }

    public static double getFullLineStretch() {
        return FULL_LINE_STRETCH_DEFAULT;
    }

    public static void setFullLineStretch(double fullLineStretch) {
        FULL_LINE_STRETCH_DEFAULT = fullLineStretch;
    }

    public static double getFullColumnStretch() {
        return FULL_COLUMN_STRETCH_DEFAULT;
    }

    public static void setFullColumnStretch(double fullStretch) {
        FULL_COLUMN_STRETCH_DEFAULT = fullStretch;
    }

    public static int verifyGapId(int gapId) {
        if (gapId < 0) {
            gapId = -gapId;
        }
        if (gapId >= DEFAULT_X_GAPS.length) {
            throw new IndexOutOfBoundsException("gapId is not in the default gap container.");
        }
        return gapId;
    }

    public static int getDefaultXGap(int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        return DEFAULT_X_GAPS[gapId];
    }

    public static void setDefaultXGap(int gap, int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        IzPanelLayout.DEFAULT_X_GAPS[gapId] = gap;
    }

    public static int getDefaultYGap(int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        return DEFAULT_Y_GAPS[gapId];
    }

    public static void setDefaultYGap(int gap, int gapId) {
        gapId = IzPanelLayout.verifyGapId(gapId);
        IzPanelLayout.DEFAULT_Y_GAPS[gapId] = gap;
    }

    public static int getDefaultTextfieldLength() {
        return DEFAULT_TEXTFIELD_LENGTH;
    }

    public static void setDefaultTextfieldLength(int val) {
        DEFAULT_TEXTFIELD_LENGTH = val;
    }

    public static class FillerComponent
    extends Component {
        private static final long serialVersionUID = 7270064864038287900L;
        private Dimension size;
        private IzPanelConstraints constraints;

        public FillerComponent() {
            this(new Dimension(0, 0));
        }

        public FillerComponent(Dimension size) {
            this(size, null);
        }

        public FillerComponent(Dimension size, IzPanelConstraints constraints) {
            this.size = size;
            this.constraints = constraints;
        }

        @Override
        public Dimension getMinimumSize() {
            return (Dimension)this.size.clone();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getMinimumSize();
        }

        @Override
        public Rectangle getBounds() {
            return this.getBounds(new Rectangle());
        }

        @Override
        public Rectangle getBounds(Rectangle rect) {
            Rectangle rectangle = rect != null ? rect : new Rectangle();
            rectangle.setBounds(0, 0, this.size.width, this.size.height);
            return rectangle;
        }

        public IzPanelConstraints getConstraints() {
            return this.constraints;
        }

        public void setConstraints(IzPanelConstraints constraints) {
            this.constraints = constraints;
        }
    }
}

