/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class MultiLineLabel
extends JComponent {
    private static final long serialVersionUID = 4051045255031894837L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEFAULT_MARGIN = 10;
    public static final int DEFAULT_ALIGN = 0;
    public static final int LEAST_ALLOWED = 200;
    private static final int FOUND = 0;
    private static final int NOT_FOUND = 1;
    private static final int NOT_DONE = 0;
    private static final int DONE = 1;
    private static final char[] WHITE_SPACE = new char[]{' ', '\n', '\t'};
    private static final char[] SPACES = new char[]{' ', '\t'};
    private static final char NEW_LINE = '\n';
    protected List<String> line = new ArrayList<String>();
    protected String labelText;
    protected int numLines;
    protected int marginHeight;
    protected int marginWidth;
    protected int lineHeight;
    protected int lineAscent;
    protected int lineDescent;
    protected int[] lineWidth;
    protected int maxWidth;
    private int maxAllowed = 200;
    private boolean maxAllowedSet = false;
    protected int alignment = 0;

    public MultiLineLabel(String text, int horMargin, int vertMargin, int maxWidth, int justify) {
        this.labelText = text;
        this.marginWidth = horMargin;
        this.marginHeight = vertMargin;
        this.maxAllowed = maxWidth;
        this.maxAllowedSet = true;
        this.alignment = justify;
    }

    public MultiLineLabel(String label, int marginWidth, int marginHeight) {
        this.labelText = label;
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
    }

    public MultiLineLabel(String label, int alignment) {
        this.labelText = label;
        this.alignment = alignment;
    }

    public MultiLineLabel(String label) {
        this.labelText = label;
    }

    int getPosition(String target, int start, char[] source, int mode) {
        int targetEnd = target.length() - 1;
        int sourceLength = source.length;
        int position = start;
        if (mode == 0) {
            boolean status = false;
            while (!status) {
                if (++position >= targetEnd) {
                    return targetEnd;
                }
                char temp = target.charAt(position);
                int scan = 0;
                while (scan < sourceLength) {
                    if (source[scan] == temp) {
                        status = true;
                    }
                    ++scan;
                }
            }
            return position;
        }
        if (mode == 1) {
            boolean status = false;
            while (!status) {
                if (++position >= targetEnd) {
                    return targetEnd;
                }
                char temp = target.charAt(position);
                status = true;
                int scan = 0;
                while (scan < sourceLength) {
                    if (source[scan] == temp) {
                        status = false;
                    }
                    ++scan;
                }
            }
            return position;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    int breakWord(String word, FontMetrics fm) {
        width = 0;
        currentPos = 0;
        endPos = word.length() - 1;
        if (endPos > 0) ** GOTO lbl7
        return currentPos;
lbl-1000:
        // 1 sources

        {
            width = fm.stringWidth(this.labelText.substring(0, ++currentPos));
lbl7:
            // 2 sources

            ** while (width < this.maxAllowed && currentPos < endPos)
        }
lbl8:
        // 1 sources

        if (currentPos != endPos) {
            --currentPos;
        }
        return currentPos;
    }

    private void divideLabel() {
        int startPos;
        int currentPos;
        this.line.clear();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int lastPos = currentPos = (startPos = 0);
        int endPos = this.labelText.length() - 1;
        while (currentPos < endPos) {
            String s;
            int width = 0;
            while (width < this.maxAllowed && currentPos < endPos && this.labelText.charAt(currentPos) != '\n') {
                lastPos = currentPos;
                currentPos = this.getPosition(this.labelText, currentPos, WHITE_SPACE, 0);
                width = fontMetrics.stringWidth(this.labelText.substring(startPos, currentPos));
            }
            if (this.labelText.charAt(currentPos) == '\n') {
                lastPos = currentPos;
            }
            if (currentPos == endPos && width <= this.maxAllowed) {
                lastPos = currentPos;
                s = this.labelText.substring(startPos);
                this.line.add(s);
            } else {
                if (lastPos == startPos) {
                    lastPos = startPos + this.breakWord(this.labelText.substring(startPos, currentPos), fontMetrics);
                }
                s = this.labelText.substring(startPos, lastPos);
                this.line.add(s);
            }
            currentPos = startPos = this.getPosition(this.labelText, lastPos, SPACES, 1);
        }
        this.numLines = this.line.size();
        this.lineWidth = new int[this.numLines];
    }

    protected void measure() {
        if (!this.maxAllowedSet) {
            this.maxAllowed = this.getParent().getSize().width;
        }
        if (this.maxAllowed < 20) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.divideLabel();
        this.lineHeight = fontMetrics.getHeight();
        this.lineDescent = fontMetrics.getDescent();
        this.maxWidth = 0;
        int i = 0;
        while (i < this.numLines) {
            this.lineWidth[i] = fontMetrics.stringWidth(this.line.get(i));
            if (this.lineWidth[i] > this.maxWidth) {
                this.maxWidth = this.lineWidth[i];
            }
            ++i;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.measure();
        Dimension size = this.getSize();
        int y = this.lineAscent + (size.height - this.numLines * this.lineHeight) / 2;
        int i = 0;
        while (i < this.numLines) {
            int x;
            y += this.lineHeight;
            switch (this.alignment) {
                case 0: {
                    x = this.marginWidth;
                    break;
                }
                case 1: {
                    x = (size.width - this.lineWidth[i]) / 2;
                    break;
                }
                case 2: {
                    x = size.width - this.marginWidth - this.lineWidth[i];
                    break;
                }
                default: {
                    x = (size.width - this.lineWidth[i]) / 2;
                }
            }
            graphics.drawString(this.line.get(i), x, y);
            ++i;
        }
    }

    public void setText(String labelText) {
        this.labelText = labelText;
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public void setColor(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setJustify(int alignment) {
        this.alignment = alignment;
        this.repaint();
    }

    public void setMaxWidth(int width) {
        this.maxAllowed = width;
        this.maxAllowedSet = true;
        this.repaint();
    }

    public void setMarginWidth(int margin) {
        this.marginWidth = margin;
        this.repaint();
    }

    public void setMarginHeight(int margin) {
        this.marginHeight = margin;
        this.repaint();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.maxAllowed = width;
        this.maxAllowedSet = true;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    @Override
    public Dimension getPreferredSize() {
        this.measure();
        return new Dimension(this.maxAllowed, this.numLines * (this.lineHeight + this.lineAscent + this.lineDescent) + 2 * this.marginHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        this.measure();
        return new Dimension(this.maxAllowed, this.numLines * (this.lineHeight + this.lineAscent + this.lineDescent) + 2 * this.marginHeight);
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }
}

