/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.base;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.DynamicVariable;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.installer.InstallerRequirementDisplay;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class InstallerBase
implements InstallerRequirementDisplay {
    private static final Logger LOGGER = Logger.getLogger(InstallerBase.class.getName());
    protected ResourceManager resourceManager;

    protected InstallerBase(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    @Override
    public abstract void showMissingRequirementMessage(String var1);

    public static void refreshDynamicVariables(AutomatedInstallData installdata, VariableSubstitutor ... substitutors) throws Exception {
        Map<String, List<DynamicVariable>> dynamicvariables = installdata.getDynamicvariables();
        RulesEngine rules = installdata.getRules();
        LOGGER.info("refreshing dynamic variables");
        if (dynamicvariables != null) {
            for (String dynvarname : dynamicvariables.keySet()) {
                LOGGER.info("Dynamic variable: " + dynvarname);
                for (DynamicVariable dynvar : dynamicvariables.get(dynvarname)) {
                    boolean refresh = true;
                    String conditionid = dynvar.getConditionid();
                    if (conditionid != null && conditionid.length() > 0 && rules != null && !rules.isConditionTrue(conditionid)) {
                        LOGGER.info("skipped refreshing dynamic variable due to unmet condition " + conditionid);
                        refresh = false;
                    }
                    if (!refresh) continue;
                    String newValue = dynvar.evaluate(substitutors);
                    if (newValue != null) {
                        LOGGER.info("dynamic variable " + dynvar.getName() + ": " + newValue);
                        installdata.getVariables().setProperty(dynvar.getName(), newValue);
                        continue;
                    }
                    LOGGER.info("dynamic variable " + dynvar.getName() + " unchanged: " + dynvar.getValue());
                }
            }
        }
    }
}

