/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.data.ParsableFile;
import com.izforge.izpack.data.UpdateCheck;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.unpacker.ScriptParser;
import com.izforge.izpack.installer.unpacker.UnpackerBase;
import com.izforge.izpack.installer.web.WebAccessor;
import com.izforge.izpack.installer.web.WebRepositoryAccessor;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public class Unpacker
extends UnpackerBase {
    private static final String tempSubPath = "/IzpackWebTemp";
    private Pack200.Unpacker unpacker;

    public Unpacker(AutomatedInstallData idata, ResourceManager resourceManager, RulesEngine rules, VariableSubstitutor variableSubstitutor, UninstallData udata) {
        super(idata, resourceManager, rules, variableSubstitutor, udata);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.addToInstances();
        try {
            fq = null;
            parsables = new ArrayList<ParsableFile>();
            executables = new ArrayList<ExecutableFile>();
            updatechecks = new ArrayList<UpdateCheck>();
            packs = this.idata.getSelectedPacks();
            npacks = packs.size();
            this.handler.startAction("Unpacking", npacks);
            customActions = this.idata.getInstallerListener();
            this.informListeners(customActions, 7, this.idata, (Integer)npacks, this.handler);
            packs = this.idata.getSelectedPacks();
            npacks = packs.size();
            i = 0;
            while (i < npacks) {
                block47: {
                    p = packs.get(i);
                    if (p.hasCondition() && this.rules != null && !this.rules.isConditionTrue(p.getCondition())) break block47;
                    this.informListeners(customActions, 5, packs.get(i), (Integer)npacks, this.handler);
                    objIn = new ObjectInputStream(this.getPackAsStream(p.id, p.uninstall));
                    nfiles = objIn.readInt();
                    pack = packs.get(i);
                    stepname = pack.name;
                    if (pack.id != null && !"".equals(pack.id) && (name = this.idata.getLangpack().getString(pack.id)) != null && !"".equals(name)) {
                        stepname = name;
                    }
                    if (pack.isHidden()) {
                        stepname = "";
                    }
                    this.handler.nextStep(stepname, i + 1, nfiles);
                    j = 0;
                    while (j < nfiles) {
                        block49: {
                            block50: {
                                block52: {
                                    block51: {
                                        block48: {
                                            pf = (PackFile)objIn.readObject();
                                            if (!pf.hasCondition() || this.rules == null || this.rules.isConditionTrue(pf.getCondition())) break block48;
                                            if (!pf.isBackReference()) {
                                                objIn.skip(pf.length());
                                            }
                                            break block49;
                                        }
                                        if (!OsConstraintHelper.oneMatchesCurrentSystem(pf.osConstraints())) break block50;
                                        path = IoHelper.translatePath(pf.getTargetPath(), this.variableSubstitutor);
                                        dest = pathFile = new File(path);
                                        if (!pf.isDirectory()) {
                                            dest = pathFile.getParentFile();
                                        }
                                        this.handleMkDirs(pf, dest);
                                        this.udata.addFile(path, pack.uninstall);
                                        if (pf.isDirectory()) break block49;
                                        this.informListeners(customActions, 1, pathFile, pf, null);
                                        this.handler.progress(j, path);
                                        if (!pathFile.exists() || pf.override() == OverrideType.OVERRIDE_TRUE || this.isOverwriteFile(pf, pathFile)) break block51;
                                        if (!pf.isBackReference() && !packs.get((int)i).loose) {
                                            if (pf.isPack200Jar()) {
                                                objIn.skip(4L);
                                            } else {
                                                objIn.skip(pf.length());
                                            }
                                        }
                                        break block49;
                                    }
                                    this.handleOverrideRename(pf, pathFile);
                                    pis = objIn;
                                    if (!pf.isBackReference()) break block52;
                                    is = this.getPackAsStream(pf.previousPackId, pack.uninstall);
                                    pis = new ObjectInputStream(is);
                                    is.skip(pf.offsetInPreviousPack - 4L);
                                    ** GOTO lbl78
                                }
                                if (!packs.get((int)i).loose) ** GOTO lbl78
                                resolvedFile = new File(this.getAbsolutInstallSource(), pf.getRelativeSourcePath());
                                if (!resolvedFile.exists()) {
                                    userDir = new File(System.getProperty("user.dir"));
                                    resolvedFile = new File(userDir, pf.getRelativeSourcePath());
                                }
                                if (!resolvedFile.exists()) {
                                    System.out.println("Could not find loosely bundled file: " + pf.getRelativeSourcePath());
                                    if (!this.handler.emitWarning("File not found", "Could not find loosely bundled file: " + pf.getRelativeSourcePath())) {
                                        throw new InstallerException("Installation cancelled");
                                    }
                                } else {
                                    pis = new FileInputStream(resolvedFile);
                                    pf = new PackFile(resolvedFile.getParentFile(), resolvedFile, pf.getTargetPath(), pf.osConstraints(), pf.override(), pf.overrideRenameTo(), pf.blockable(), pf.getAdditionals());
lbl78:
                                    // 3 sources

                                    tmpFile = null;
                                    if (this.blockableForCurrentOs(pf)) {
                                        tmpFile = File.createTempFile("__FQ__", null, pathFile.getParentFile());
                                        out = new FileOutputStream(tmpFile);
                                    } else {
                                        out = new FileOutputStream(pathFile);
                                    }
                                    if (pf.isPack200Jar()) {
                                        key = objIn.readInt();
                                        pack200Input = this.resourceManager.getInputStream("/packs/pack200-" + key);
                                        unpacker = this.getPack200Unpacker();
                                        jarOut = new JarOutputStream(out);
                                        unpacker.unpack(pack200Input, jarOut);
                                        jarOut.close();
                                    } else {
                                        buffer = new byte[5120];
                                        bytesCopied = 0L;
                                        while (bytesCopied < pf.length()) {
                                            if (this.performInterrupted()) {
                                                out.close();
                                                if (pis != objIn) {
                                                    pis.close();
                                                }
                                                return;
                                            }
                                            bytesCopied = this.writeBuffer(pf, buffer, out, pis, bytesCopied);
                                        }
                                        out.close();
                                    }
                                    if (pis != objIn) {
                                        pis.close();
                                    }
                                    this.handleTimeStamp(pf, pathFile, tmpFile);
                                    fq = this.handleBlockable(pf, pathFile, tmpFile, fq, customActions);
                                }
                                break block49;
                            }
                            if (!pf.isBackReference()) {
                                objIn.skip(pf.length());
                            }
                        }
                        ++j;
                    }
                    numParsables = objIn.readInt();
                    k = 0;
                    while (k < numParsables) {
                        pf = (ParsableFile)objIn.readObject();
                        if (!pf.hasCondition() || this.rules == null || this.rules.isConditionTrue(pf.getCondition())) {
                            pf.path = IoHelper.translatePath(pf.path, this.variableSubstitutor);
                            parsables.add(pf);
                        }
                        ++k;
                    }
                    this.loadExecutables(objIn, executables);
                    numUpdateChecks = objIn.readInt();
                    k = 0;
                    while (k < numUpdateChecks) {
                        updateCheck = (UpdateCheck)objIn.readObject();
                        updatechecks.add(updateCheck);
                        ++k;
                    }
                    objIn.close();
                    if (this.performInterrupted()) {
                        return;
                    }
                    this.informListeners(customActions, 6, packs.get(i), (Integer)i, this.handler);
                }
                ++i;
            }
            if (fq != null) {
                fq.execute();
                this.idata.setRebootNecessary(fq.isRebootNecessary());
            }
            parser = new ScriptParser(parsables, this.variableSubstitutor);
            parser.parseFiles();
            if (this.performInterrupted()) {
                return;
            }
            executor = new FileExecutor(executables);
            if (executor.executeFiles(0, this.handler) != 0) {
                this.handler.emitError("File execution failed", "The installation was not completed");
                this.result = false;
            }
            if (this.performInterrupted()) {
                return;
            }
            this.performUpdateChecks(updatechecks);
            if (this.performInterrupted()) {
                return;
            }
            if (this.performInterrupted()) {
                return;
            }
            try {
                this.writeInstallationInformation();
                this.handler.stopAction();
            }
            catch (Exception err) {
                this.handler.stopAction();
                message = err.getMessage();
                if ("Installation cancelled".equals(message)) {
                    this.handler.emitNotification("Installation cancelled");
                } else {
                    if (message == null || "".equals(message)) {
                        message = "Internal error occured : " + err.toString();
                    }
                    this.handler.emitError("An error occured", message);
                    err.printStackTrace();
                }
                this.result = false;
                Housekeeper.getInstance().shutDown(4);
            }
        }
        finally {
            this.removeFromInstances();
        }
    }

    private Pack200.Unpacker getPack200Unpacker() {
        if (this.unpacker == null) {
            this.unpacker = Pack200.newUnpacker();
        }
        return this.unpacker;
    }

    private InputStream getPackAsStream(String packid, boolean uninstall) throws Exception {
        InputStream in;
        String webDirURL = this.idata.getInfo().getWebDirURL();
        packid = "-" + packid;
        if (webDirURL == null) {
            in = this.resourceManager.getInputStream("packs/pack" + packid);
        } else {
            String tempfile;
            String baseName = this.idata.getInfo().getInstallerBase();
            String packURL = String.valueOf(webDirURL) + "/" + baseName + ".pack" + packid + ".jar";
            String tempFolder = IoHelper.translatePath(String.valueOf(this.idata.getInfo().getUninstallerPath()) + tempSubPath, this.variableSubstitutor);
            try {
                tempfile = WebRepositoryAccessor.getCachedUrl(packURL, tempFolder);
                this.udata.addFile(tempfile, uninstall);
            }
            catch (Exception e) {
                if ("Cancelled".equals(e.getMessage())) {
                    throw new InstallerException("Installation cancelled", e);
                }
                throw new InstallerException("Installation failed", e);
            }
            URL url = new URL("jar:" + tempfile + "!/packs/pack" + packid);
            in = new WebAccessor(null).openInputStream(url);
            if (in == null) {
                throw new InstallerException(String.valueOf(url.toString()) + " not available", new FileNotFoundException(url.toString()));
            }
        }
        if (in != null && this.idata.getInfo().getPackDecoderClassName() != null) {
            Class<?> decoder = Class.forName(this.idata.getInfo().getPackDecoderClassName());
            Class[] paramsClasses = new Class[]{Class.forName("java.io.InputStream")};
            Constructor<?> constructor = decoder.getDeclaredConstructor(paramsClasses);
            BufferedInputStream buffer = new BufferedInputStream(in);
            Object[] params = new Object[]{buffer};
            Object instance = null;
            instance = constructor.newInstance(params);
            if (!InputStream.class.isInstance(instance)) {
                throw new InstallerException("'" + this.idata.getInfo().getPackDecoderClassName() + "' must be derived from " + InputStream.class.toString());
            }
            in = instance;
        }
        return in;
    }
}

