/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.file;

import com.izforge.izpack.api.exception.MergeException;
import com.izforge.izpack.merge.AbstractMerge;
import com.izforge.izpack.merge.resolve.ResolveUtils;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tools.zip.ZipOutputStream;

public class FileMerge
extends AbstractMerge {
    private File sourceToCopy;
    private String destination;

    public FileMerge(URL url, Map<OutputStream, List<String>> mergeContent) {
        this(url, "", mergeContent);
    }

    public FileMerge(URL url, String destination, Map<OutputStream, List<String>> mergeContent) {
        this.mergeContent = mergeContent;
        this.sourceToCopy = FileUtil.convertUrlToFile(url);
        this.destination = destination;
    }

    @Override
    public File find(FileFilter fileFilter) {
        return this.findRecursivelyForFile(fileFilter, this.sourceToCopy);
    }

    @Override
    public List<File> recursivelyListFiles(FileFilter fileFilter) {
        ArrayList<File> result = new ArrayList<File>();
        this.findRecursivelyForFiles(fileFilter, this.sourceToCopy, result);
        return result;
    }

    private File findRecursivelyForFile(FileFilter fileFilter, File currentFile) {
        if (currentFile.isDirectory()) {
            File[] fileArray = currentFile.listFiles(fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File files = fileArray[n2];
                File file = this.findRecursivelyForFile(fileFilter, files);
                if (file != null) {
                    return file;
                }
                ++n2;
            }
        } else {
            return currentFile;
        }
        return null;
    }

    private void findRecursivelyForFiles(FileFilter fileFilter, File currentFile, List<File> result) {
        if (currentFile.isDirectory()) {
            File[] fileArray = currentFile.listFiles(fileFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File files = fileArray[n2];
                result.add(currentFile);
                this.findRecursivelyForFiles(fileFilter, files, result);
                ++n2;
            }
        } else {
            result.add(currentFile);
        }
    }

    @Override
    public void merge(ZipOutputStream outputStream) {
        List<String> mergeList = this.getMergeList(outputStream);
        try {
            if (mergeList.contains(this.sourceToCopy.getAbsolutePath())) {
                return;
            }
            mergeList.add(this.sourceToCopy.getAbsolutePath());
            this.copyFileToJar(this.sourceToCopy, outputStream);
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
    }

    @Override
    public void merge(java.util.zip.ZipOutputStream outputStream) {
        try {
            this.copyFileToJar(this.sourceToCopy, outputStream);
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
    }

    private void copyFileToJar(File fileToCopy, java.util.zip.ZipOutputStream outputStream) throws IOException {
        if (fileToCopy.isDirectory()) {
            File[] fileArray = fileToCopy.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.copyFileToJar(file, outputStream);
                ++n2;
            }
        } else {
            String entryName = this.resolveName(fileToCopy, this.destination);
            List<String> mergeList = this.getMergeList(outputStream);
            if (mergeList.contains(entryName)) {
                return;
            }
            mergeList.add(entryName);
            FileInputStream inputStream = new FileInputStream(fileToCopy);
            IoHelper.copyStreamToJar((InputStream)inputStream, outputStream, entryName, fileToCopy.lastModified());
            inputStream.close();
        }
    }

    private void copyFileToJar(File fileToCopy, ZipOutputStream outputStream) throws IOException {
        FileInputStream inputStream = null;
        if (fileToCopy.isDirectory()) {
            File[] fileArray = fileToCopy.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.copyFileToJar(file, outputStream);
                ++n2;
            }
        } else {
            inputStream = new FileInputStream(fileToCopy);
        }
        String entryName = this.resolveName(fileToCopy, this.destination);
        List<String> mergeList = this.getMergeList(outputStream);
        if (mergeList.contains(entryName)) {
            return;
        }
        mergeList.add(entryName);
        if (inputStream != null) {
            IoHelper.copyStreamToJar((InputStream)inputStream, outputStream, entryName, fileToCopy.lastModified());
            inputStream.close();
        }
    }

    private String resolveName(File fileToCopy, String destination) {
        if (this.isFile(destination)) {
            return destination;
        }
        String path = ResolveUtils.convertPathToPosixPath(this.sourceToCopy.getAbsolutePath());
        if (destination.equals("")) {
            path = ResolveUtils.convertPathToPosixPath(this.sourceToCopy.getParentFile().getAbsolutePath());
        }
        path = String.valueOf(path) + '/';
        StringBuilder builder = new StringBuilder();
        builder.append(destination);
        String absolutePath = ResolveUtils.convertPathToPosixPath(fileToCopy.getAbsolutePath());
        builder.append(absolutePath.replaceAll(path, ""));
        return builder.toString().replaceAll("//", "/");
    }

    private boolean isFile(String destination) {
        if (destination.length() == 0) {
            return false;
        }
        if (!destination.contains("/")) {
            return true;
        }
        return !destination.endsWith("/");
    }

    public String toString() {
        return "FileMerge{sourceToCopy=" + this.sourceToCopy + ", destination='" + this.destination + '\'' + '}';
    }
}

