/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.jar;

import com.izforge.izpack.api.exception.MergeException;
import com.izforge.izpack.merge.AbstractMerge;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.IoHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.zip.ZipOutputStream;

public class JarMerge
extends AbstractMerge {
    private String jarPath;
    private String regexp;
    private String destination;

    public JarMerge(URL resource, String jarPath, Map<OutputStream, List<String>> mergeContent) {
        this.jarPath = jarPath;
        this.mergeContent = mergeContent;
        this.destination = FileUtil.convertUrlToFilePath(resource).replaceAll(this.jarPath, "").replaceAll("file:", "").replaceAll("!/?", "").replaceAll("//", "/");
        StringBuilder builder = new StringBuilder().append(this.destination);
        if (this.destination.endsWith("/")) {
            builder.append("+(.*)");
        } else {
            builder.append("/*(.*)");
        }
        this.regexp = builder.toString();
    }

    public JarMerge(String jarPath, String pathInsideJar, String destination, Map<OutputStream, List<String>> mergeContent) {
        this.jarPath = jarPath;
        this.destination = destination;
        this.mergeContent = mergeContent;
        StringBuilder builder = new StringBuilder().append(pathInsideJar);
        if (pathInsideJar.endsWith("/")) {
            builder.append("+(.*)");
        } else {
            builder.append("/*(.*)");
        }
        this.regexp = builder.toString();
    }

    @Override
    public File find(FileFilter fileFilter) {
        try {
            ArrayList<String> fileNameInZip = this.getFileNameInZip();
            for (String fileName : fileNameInZip) {
                File file = new File(String.valueOf(this.jarPath) + "!/" + fileName);
                if (!fileFilter.accept(file)) continue;
                return file;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public List<File> recursivelyListFiles(FileFilter fileFilter) {
        try {
            ArrayList<String> fileNameInZip = this.getFileNameInZip();
            ArrayList<File> result = new ArrayList<File>();
            ArrayList<File> filteredResult = new ArrayList<File>();
            for (String fileName : fileNameInZip) {
                result.add(new File(String.valueOf(this.jarPath) + "!" + fileName));
            }
            for (File file : result) {
                if (!fileFilter.accept(file)) continue;
                filteredResult.add(file);
            }
            return filteredResult;
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
    }

    public ArrayList<String> getFileNameInZip() throws IOException {
        ZipEntry zipEntry;
        ZipInputStream inputStream = new ZipInputStream(new FileInputStream(this.jarPath));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((zipEntry = inputStream.getNextEntry()) != null) {
            arrayList.add(zipEntry.getName());
        }
        return arrayList;
    }

    @Override
    public void merge(java.util.zip.ZipOutputStream outputStream) {
        Pattern pattern = Pattern.compile(this.regexp);
        List<String> mergeList = this.getMergeList(outputStream);
        try {
            ZipEntry zentry;
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(new File(this.jarPath)));
            while ((zentry = jarInputStream.getNextEntry()) != null) {
                Matcher matcher = pattern.matcher(zentry.getName());
                if (!matcher.matches() || mergeList.contains(zentry.getName())) continue;
                mergeList.add(zentry.getName());
                String matchFile = matcher.group(1);
                StringBuilder dest = new StringBuilder(this.destination);
                if (matchFile != null && matchFile.length() > 0) {
                    if (dest.length() > 0 && dest.charAt(dest.length() - 1) != '/') {
                        dest.append('/');
                    }
                    dest.append(matchFile);
                }
                IoHelper.copyStreamToJar((InputStream)jarInputStream, outputStream, dest.toString().replaceAll("//", "/"), zentry.getTime());
            }
            jarInputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void merge(ZipOutputStream outJar) {
        Pattern pattern = Pattern.compile(this.regexp);
        List<String> mergeList = this.getMergeList(outJar);
        try {
            ZipEntry zentry;
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(new File(this.jarPath)));
            while ((zentry = jarInputStream.getNextEntry()) != null) {
                Matcher matcher = pattern.matcher(zentry.getName());
                if (!matcher.matches() || mergeList.contains(zentry.getName())) continue;
                mergeList.add(zentry.getName());
                String matchFile = matcher.group(1);
                StringBuilder dest = new StringBuilder(this.destination);
                if (matchFile != null && matchFile.length() > 0) {
                    if (dest.length() > 0 && dest.charAt(dest.length() - 1) != '/') {
                        dest.append('/');
                    }
                    dest.append(matchFile);
                }
                IoHelper.copyStreamToJar((InputStream)jarInputStream, outJar, dest.toString().replaceAll("//", "/"), zentry.getTime());
            }
            jarInputStream.close();
        }
        catch (IOException e) {
            throw new MergeException(e);
        }
    }

    public String toString() {
        return "JarMerge{jarPath='" + this.jarPath + '\'' + ", regexp='" + this.regexp + '\'' + ", destination='" + this.destination + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarMerge jarMerge = (JarMerge)o;
        return !(this.jarPath != null ? !this.jarPath.equals(jarMerge.jarPath) : jarMerge.jarPath != null);
    }

    public int hashCode() {
        return this.jarPath != null ? this.jarPath.hashCode() : 0;
    }
}

