/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.panel;

import com.izforge.izpack.api.merge.Mergeable;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.zip.ZipOutputStream;

public class PanelMerge
implements Mergeable {
    private List<Mergeable> packageMerge;
    private Class panelClass;
    private FileFilter fileFilter;

    public PanelMerge(final Class panelClass, List<Mergeable> packageMergeable) {
        this.panelClass = panelClass;
        this.packageMerge = packageMergeable;
        this.fileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getAbsolutePath().contains("/" + panelClass + ".class");
            }
        };
    }

    @Override
    public void merge(ZipOutputStream outputStream) {
        for (Mergeable mergeable : this.packageMerge) {
            mergeable.merge(outputStream);
        }
    }

    @Override
    public List<File> recursivelyListFiles(FileFilter fileFilter) {
        ArrayList<File> result = new ArrayList<File>();
        for (Mergeable mergeable : this.packageMerge) {
            result.addAll(mergeable.recursivelyListFiles(fileFilter));
        }
        return result;
    }

    @Override
    public File find(FileFilter fileFilter) {
        for (Mergeable mergeable : this.packageMerge) {
            File file = mergeable.find(fileFilter);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Override
    public void merge(java.util.zip.ZipOutputStream outputStream) {
        for (Mergeable mergeable : this.packageMerge) {
            mergeable.merge(outputStream);
        }
    }

    public Class getPanelClass() {
        return this.panelClass;
    }

    public String toString() {
        return "PanelMerge{packageMerge=" + this.packageMerge + ", panelClass=" + this.panelClass + ", fileFilter=" + this.fileFilter + '}';
    }
}

