/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.resolve;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.exception.MergeException;
import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.merge.ClassResolver;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import com.izforge.izpack.util.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClassPathCrawler {
    private MergeableResolver mergeableResolver;
    private HashMap<String, Set<URL>> classPathContentCache;
    private static final List<String> acceptedJar = Arrays.asList(".*event.*", ".*panel.*", ".*izpack.*");

    public ClassPathCrawler(MergeableResolver mergeableResolver) {
        this.mergeableResolver = mergeableResolver;
    }

    public String getCurrentClasspath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (URL url : this.getClassPathUrl()) {
            stringBuilder.append(FileUtil.convertUrlToFilePath(url));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public void processClassPath() {
        if (this.classPathContentCache != null) {
            return;
        }
        this.classPathContentCache = new HashMap();
        try {
            Set<URL> urls = this.getClassPathUrl();
            for (URL url : urls) {
                Mergeable mergeable = this.mergeableResolver.getMergeableFromURL(url);
                List<File> files = mergeable.recursivelyListFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return true;
                    }
                });
                if (files == null) continue;
                for (File file : files) {
                    this.getOrCreateList(this.classPathContentCache, file.getName()).add(file.toURI().toURL());
                }
            }
        }
        catch (Exception e) {
            throw new MergeException(e);
        }
    }

    private Set<URL> getOrCreateList(HashMap<String, Set<URL>> classPathContentCache, String key) {
        String newKey = key;
        if (key.contains("jar!")) {
            newKey = key.substring(key.indexOf("!") + 1);
        }
        if (!classPathContentCache.containsKey(newKey)) {
            classPathContentCache.put(newKey, new HashSet());
        }
        return classPathContentCache.get(newKey);
    }

    public Class searchClassInClassPath(String className) {
        if (ClassResolver.isFullClassName(className)) {
            try {
                return this.getClass().getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new MergeException("The class name " + className + " is not a valid", e);
            }
        }
        try {
            String fileToSearch = String.valueOf(className) + ".class";
            this.processClassPath();
            Set<URL> urlList = this.classPathContentCache.get(fileToSearch);
            if (urlList != null) {
                String fullClassName = ClassResolver.processURLToClassName(urlList.iterator().next());
                return this.getClass().getClassLoader().loadClass(fullClassName);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new MergeException("Could not find class " + className + " : Current classpath is " + this.getCurrentClasspath());
    }

    public Set<URL> searchPackageInClassPath(String packageName) {
        this.processClassPath();
        String formatPackageName = packageName.replaceAll("/", ".").replaceAll("\\.$", "");
        String[] parts = formatPackageName.replaceAll("/", ".").split("\\.");
        if (parts.length == 1) {
            return this.classPathContentCache.get(formatPackageName);
        }
        return this.getUrlsForPackage(formatPackageName);
    }

    public Set<URL> getUrlsForPackage(String packageName) {
        HashSet<URL> resultSet = new HashSet<URL>();
        Set<URL> urls = this.classPathContentCache.get(ClassResolver.getLastPackagePart(packageName));
        if (urls == null) {
            throw new IzPackException("The package " + packageName + " has not been found in the classpath and is required by the installer");
        }
        for (URL url : urls) {
            if (!ClassResolver.isUrlContainingPackage(url, packageName)) continue;
            resultSet.add(url);
        }
        return resultSet;
    }

    private URL getCurrentJarUrl() throws IOException {
        String className = this.getClass().getName();
        URL classUrl = this.getClass().getResource("/" + className.replace('.', '/') + ".class");
        if (classUrl.getProtocol().equals("jar")) {
            return ((JarURLConnection)classUrl.openConnection()).getJarFileURL();
        }
        return null;
    }

    private Set<URL> getClassPathUrl() {
        HashSet<URL> result = new HashSet<URL>();
        URLClassLoader loader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        result.addAll(Arrays.asList(loader.getURLs()));
        URL currentJarUrl = null;
        try {
            Enumeration<URL> urlEnumeration = loader.getResources("");
            result.addAll(Collections.list(urlEnumeration));
            urlEnumeration = loader.getResources("META-INF/");
            result.addAll(Collections.list(urlEnumeration));
            currentJarUrl = this.getCurrentJarUrl();
        }
        catch (IOException urlEnumeration) {
            // empty catch block
        }
        Set<URL> filteredUrls = this.filterUrl(result, acceptedJar);
        if (currentJarUrl != null) {
            filteredUrls.add(currentJarUrl);
        }
        return filteredUrls;
    }

    private Set<URL> filterUrl(Set<URL> urlCollection, List<String> acceptedRegexp) {
        HashSet<URL> result = new HashSet<URL>();
        for (URL url : urlCollection) {
            for (String regexp : acceptedRegexp) {
                if (!FileUtil.convertUrlToFilePath(url).matches(regexp)) continue;
                result.add(url);
            }
        }
        return result;
    }
}

