/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.merge.resolve;

import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.merge.panel.PanelMerge;
import com.izforge.izpack.merge.resolve.ClassPathCrawler;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import com.izforge.izpack.merge.resolve.ResolveUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class PathResolver {
    public MergeableResolver mergeableResolver;
    private ClassPathCrawler classPathCrawler;
    private Properties panelDependencies;

    public PathResolver(MergeableResolver mergeableResolver, ClassPathCrawler classPathCrawler, Properties panelDependencies) throws IOException {
        this.mergeableResolver = mergeableResolver;
        this.classPathCrawler = classPathCrawler;
        this.panelDependencies = panelDependencies;
    }

    public Set<URL> resolvePath(String sourcePath) {
        HashSet<URL> result = new HashSet<URL>();
        URL path = ResolveUtils.getFileFromPath(sourcePath);
        if (path != null) {
            result.add(path);
        }
        try {
            URLClassLoader contextClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Enumeration<URL> urlEnumeration = contextClassLoader.findResources(sourcePath);
            while (urlEnumeration.hasMoreElements()) {
                URL url = urlEnumeration.nextElement();
                result.add(url);
            }
        }
        catch (IOException e) {
            throw new IzPackException(e);
        }
        if (!result.isEmpty()) {
            return result;
        }
        Set<URL> urlList = this.classPathCrawler.searchPackageInClassPath(sourcePath);
        if (urlList != null) {
            return urlList;
        }
        throw new IzPackException("The path " + sourcePath + " is not present inside the classpath.\n The current classpath is :" + ResolveUtils.getCurrentClasspath());
    }

    public List<Mergeable> getMergeableFromPath(String resourcePath) {
        Set<URL> urlList = this.resolvePath(resourcePath);
        ArrayList<Mergeable> result = new ArrayList<Mergeable>();
        for (URL url : urlList) {
            result.add(this.mergeableResolver.getMergeableFromURL(url, resourcePath));
        }
        return result;
    }

    public List<Mergeable> getMergeableFromPackageName(String dependPackage) {
        return this.getMergeableFromPath(String.valueOf(dependPackage.replaceAll("\\.", "/")) + "/");
    }

    public List<Mergeable> getMergeableJarFromPackageName(String packageName) {
        Set<URL> urlSet = ResolveUtils.getJarUrlForPackage(packageName);
        ArrayList<Mergeable> list = new ArrayList<Mergeable>();
        for (URL url : urlSet) {
            list.add(this.mergeableResolver.getMergeableFromURL(url));
        }
        return list;
    }

    public List<Mergeable> getMergeableFromPath(String resourcePath, String destination) {
        Set<URL> urlList = this.resolvePath(resourcePath);
        ArrayList<Mergeable> result = new ArrayList<Mergeable>();
        for (URL url : urlList) {
            result.add(this.mergeableResolver.getMergeableFromURLWithDestination(url, destination));
        }
        return result;
    }

    public PanelMerge getPanelMerge(String className) {
        Class aClass = this.classPathCrawler.searchClassInClassPath(className);
        List<Mergeable> mergeableForClass = this.getMergeablePackage(aClass.getPackage());
        if (this.panelDependencies.containsKey(aClass.getSimpleName())) {
            String dependPackage = (String)this.panelDependencies.get(aClass.getSimpleName());
            mergeableForClass.addAll(this.getMergeableFromPackageName(dependPackage));
        }
        return new PanelMerge(aClass, mergeableForClass);
    }

    public List<Mergeable> getMergeablePackage(Package aPackage) {
        ArrayList<Mergeable> mergeables = new ArrayList<Mergeable>();
        String destination = aPackage.getName().replaceAll("\\.", "/");
        Set<URL> obtainPackages = this.classPathCrawler.searchPackageInClassPath(aPackage.getName());
        for (URL obtainPackage : obtainPackages) {
            mergeables.add(this.mergeableResolver.getMergeableFromURLWithDestination(obtainPackage, String.valueOf(destination) + "/"));
        }
        return mergeables;
    }
}

