/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.packs;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.base.InstallerFrame;
import com.izforge.izpack.installer.base.IzPanel;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.debugger.Debugger;
import com.izforge.izpack.panels.imgpacks.ImgPacksPanelAutomationHelper;
import com.izforge.izpack.panels.packs.PacksModel;
import com.izforge.izpack.panels.packs.PacksPanelInterface;
import com.izforge.izpack.panels.treepacks.PackValidator;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public abstract class PacksPanelBase
extends IzPanel
implements PacksPanelInterface,
ListSelectionListener {
    protected JLabel freeSpaceLabel;
    protected JLabel spaceLabel;
    protected JTextArea descriptionArea;
    protected JTextArea dependencyArea;
    protected JTable packsTable;
    protected PacksModel packsModel;
    protected JScrollPane tableScroller;
    private Map<String, Pack> names;
    protected long bytes = 0L;
    protected long freeBytes = 0L;
    protected boolean dependenciesExist = false;
    private LocaleDatabase langpack = null;
    private static final String LANG_FILE_NAME = "packsLang.xml";
    private Debugger debugger;
    private RulesEngine rules;

    public PacksPanelBase(InstallerFrame parent, GUIInstallData idata, ResourceManager resourceManager, RulesEngine rules) {
        super(parent, idata, resourceManager);
        this.rules = rules;
        try {
            this.langpack = this.installData.getLangpack();
            InputStream inputStream = this.resourceManager.getInputStream(LANG_FILE_NAME);
            this.langpack.add(inputStream);
            this.debugger = parent.getDebugger();
        }
        catch (Throwable exception) {
            Debug.trace(exception);
        }
        this.computePacks(idata.getAvailablePacks());
        this.createNormalLayout();
        this.packsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int row = PacksPanelBase.this.packsTable.rowAtPoint(event.getPoint());
                int col = PacksPanelBase.this.packsTable.columnAtPoint(event.getPoint());
                if (col == 0) {
                    Integer checked = (Integer)PacksPanelBase.this.packsModel.getValueAt(row, 0);
                    checked = checked <= 0 ? 1 : 0;
                    PacksPanelBase.this.packsModel.setValueAt(checked, row, 0);
                    PacksPanelBase.this.packsTable.repaint();
                }
            }
        });
    }

    protected abstract void createNormalLayout();

    @Override
    public LocaleDatabase getLangpack() {
        return this.langpack;
    }

    @Override
    public long getBytes() {
        return this.bytes;
    }

    @Override
    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    @Override
    public void showSpaceRequired() {
        if (this.spaceLabel != null) {
            this.spaceLabel.setText(Pack.toByteUnitsString(this.bytes));
        }
    }

    @Override
    public void showFreeSpace() {
        if (IoHelper.supported("getFreeSpace") && this.freeSpaceLabel != null) {
            this.freeBytes = IoHelper.getFreeSpace(IoHelper.existingParent(new File(this.installData.getInstallPath())).getAbsolutePath());
            String msg = this.freeBytes < 0L ? this.installData.getLangpack().getString("PacksPanel.notAscertainable") : Pack.toByteUnitsString(this.freeBytes);
            this.freeSpaceLabel.setText(msg);
        }
    }

    @Override
    public boolean isValidated() {
        if (IoHelper.supported("getFreeSpace") && this.freeBytes >= 0L && this.freeBytes <= this.bytes) {
            JOptionPane.showMessageDialog(this, this.installData.getLangpack().getString("PacksPanel.notEnoughSpace"), this.installData.getLangpack().getString("installer.error"), 0);
            return false;
        }
        for (Pack pack : this.installData.getAvailablePacks()) {
            for (String validator : pack.getValidators()) {
                PackValidator validatorInst;
                try {
                    validatorInst = (PackValidator)Class.forName(validator).newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Error: Validator class " + validator + " for pack " + pack.name + " not available.");
                    continue;
                }
                try {
                    if (validatorInst.validate((AbstractUIHandler)this, this.installData, pack.id, this.installData.getSelectedPacks().indexOf(pack) > -1)) continue;
                    return false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Error: Exception in " + validator + ".validate(" + (this.installData.getSelectedPacks().indexOf(pack) > -1) + ") for pack " + pack.name);
                }
            }
        }
        return true;
    }

    @Override
    public void makeXMLData(IXMLElement panelRoot) {
        new ImgPacksPanelAutomationHelper().makeXMLData((AutomatedInstallData)this.installData, panelRoot);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Pack pack;
        int selectedRow = this.packsTable.getSelectedRow();
        if (this.descriptionArea != null && selectedRow != -1) {
            pack = this.packsModel.getPackAtRow(selectedRow);
            String desc = "";
            String key = String.valueOf(pack.id) + ".description";
            if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
                desc = this.langpack.getString(key);
            }
            if ("".equals(desc) || key.equals(desc)) {
                desc = pack.description;
            }
            try {
                desc = this.variableSubstitutor.substitute(desc);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.descriptionArea.setText(desc);
        }
        if (this.dependencyArea != null && selectedRow != -1) {
            pack = this.packsModel.getPackAtRow(selectedRow);
            List<String> dep = pack.dependencies;
            String list = "";
            if (dep != null) {
                list = String.valueOf(list) + (this.langpack == null ? "Dependencies: " : this.langpack.getString("PacksPanel.dependencies"));
            }
            int j = 0;
            while (dep != null && j < dep.size()) {
                String name = dep.get(j);
                list = String.valueOf(list) + this.getI18NPackName(this.names.get(name));
                if (j != dep.size() - 1) {
                    list = String.valueOf(list) + ", ";
                }
                ++j;
            }
            String excludeslist = this.langpack == null ? "Excludes: " : this.langpack.getString("PacksPanel.excludes");
            int numexcludes = 0;
            if (pack.excludeGroup != null) {
                int q = 0;
                while (q < this.installData.getAvailablePacks().size()) {
                    Pack otherpack = this.installData.getAvailablePacks().get(q);
                    String exgroup = otherpack.excludeGroup;
                    if (exgroup != null && q != selectedRow && pack.excludeGroup.equals(exgroup)) {
                        excludeslist = String.valueOf(excludeslist) + this.getI18NPackName(otherpack) + ", ";
                        ++numexcludes;
                    }
                    ++q;
                }
            }
            if (dep != null) {
                excludeslist = "    " + excludeslist;
            }
            if (numexcludes > 0) {
                list = String.valueOf(list) + excludeslist;
            }
            if (list.endsWith(", ")) {
                list = list.substring(0, list.length() - 2);
            }
            this.dependencyArea.setText(list);
        }
    }

    private String getI18NPackName(Pack pack) {
        String packName = pack.name;
        String key = pack.id;
        if (this.langpack != null && pack.id != null && !"".equals(pack.id)) {
            packName = this.langpack.getString(key);
        }
        if ("".equals(packName) || key == null || key.equals(packName)) {
            packName = pack.name;
        }
        return packName;
    }

    protected JLabel createLabel(String msgId, String iconId, GridBagLayout layout, GridBagConstraints constraints) {
        JLabel label = LabelFactory.create(this.installData.getLangpack().getString(msgId), (Icon)this.parent.getIcons().get(iconId), 11);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(label, constraints);
        }
        this.add(label);
        return label;
    }

    protected JLabel createPanelWithLabel(String msgId, GridBagLayout layout, GridBagConstraints constraints) {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        panel.setAlignmentX(0.0f);
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(LabelFactory.create(this.installData.getLangpack().getString(msgId)));
        panel.add(Box.createHorizontalGlue());
        panel.add(label);
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(panel, constraints);
        }
        this.add(panel);
        boolean doNotShowRequiredSize = Boolean.parseBoolean(this.installData.guiPrefs.modifier.get("doNotShowRequiredSize"));
        panel.setVisible(!doNotShowRequiredSize);
        return label;
    }

    protected JTextArea createTextArea(String msgId, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTextArea area = new JTextArea();
        area.setAlignmentX(0.0f);
        area.setCaretPosition(0);
        area.setEditable(false);
        area.setEditable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setBorder(BorderFactory.createTitledBorder(this.installData.getLangpack().getString(msgId)));
        area.setFont(this.getControlTextFont());
        if (layout != null && constraints != null) {
            if (scroller != null) {
                layout.addLayoutComponent(scroller, constraints);
            } else {
                layout.addLayoutComponent(area, constraints);
            }
        }
        if (scroller != null) {
            scroller.setViewportView(area);
            this.add(scroller);
        } else {
            this.add(area);
        }
        return area;
    }

    protected JTable createPacksTable(int width, JScrollPane scroller, GridBagLayout layout, GridBagConstraints constraints) {
        JTable table = new JTable();
        table.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        table.setIntercellSpacing(new Dimension(0, 0));
        table.setBackground(Color.white);
        table.setSelectionMode(0);
        table.getSelectionModel().addListSelectionListener(this);
        table.setShowGrid(false);
        scroller.setViewportView(table);
        scroller.setAlignmentX(0.0f);
        scroller.getViewport().setBackground(Color.white);
        scroller.setPreferredSize(new Dimension(width, this.installData.guiPrefs.height / 3 + 30));
        if (layout != null && constraints != null) {
            layout.addLayoutComponent(scroller, constraints);
        }
        this.add(scroller);
        return table;
    }

    private void computePacks(List<Pack> packs) {
        this.names = new HashMap<String, Pack>();
        this.dependenciesExist = false;
        for (Pack pack : packs) {
            this.names.put(pack.name, pack);
            if (pack.dependencies == null && pack.excludeGroup == null) continue;
            this.dependenciesExist = true;
        }
    }

    @Override
    public void panelActivate() {
        try {
            this.packsModel = new PacksModel(this, this.installData, this.rules){

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return false;
                }
            };
            this.packsTable.setModel(this.packsModel);
            CheckBoxRenderer packSelectedRenderer = new CheckBoxRenderer();
            this.packsTable.getColumnModel().getColumn(0).setCellRenderer(packSelectedRenderer);
            this.packsTable.getColumnModel().getColumn(0).setMaxWidth(40);
            this.packsTable.getColumnModel().getColumn(1).setCellRenderer(new PacksPanelTableCellRenderer());
            PacksPanelTableCellRenderer packTextColumnRenderer = new PacksPanelTableCellRenderer();
            packTextColumnRenderer.setHorizontalAlignment(4);
            if (this.packsTable.getColumnCount() > 2) {
                this.packsTable.getColumnModel().getColumn(2).setCellRenderer(packTextColumnRenderer);
                this.packsTable.getColumnModel().getColumn(2).setMaxWidth(100);
            }
            this.tableScroller.remove(this.packsTable.getTableHeader());
            this.tableScroller.setColumnHeaderView(null);
            this.tableScroller.setColumnHeader(null);
            this.bytes = 0L;
            for (Pack p : this.installData.getAvailablePacks()) {
                if (p.required) {
                    this.bytes += p.nbytes;
                    continue;
                }
                if (!this.installData.getSelectedPacks().contains(p)) continue;
                this.bytes += p.nbytes;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.showSpaceRequired();
        this.showFreeSpace();
        this.packsTable.setRowSelectionInterval(0, 0);
    }

    @Override
    public String getSummaryBody() {
        StringBuffer retval = new StringBuffer(256);
        boolean first = true;
        for (Pack pack : this.installData.getSelectedPacks()) {
            if (!first) {
                retval.append("<br>");
            }
            first = false;
            retval.append(this.getI18NPackName(pack));
        }
        if (this.packsModel.isModifyinstallation()) {
            Map<String, Pack> installedpacks = this.packsModel.getInstalledpacks();
            retval.append("<br><b>");
            retval.append(this.langpack.getString("PacksPanel.installedpacks.summarycaption"));
            retval.append("</b>");
            retval.append("<br>");
            for (String key : installedpacks.keySet()) {
                Pack pack = installedpacks.get(key);
                retval.append(this.getI18NPackName(pack));
                retval.append("<br>");
            }
        }
        return retval.toString();
    }

    @Override
    public Debugger getDebugger() {
        return this.debugger;
    }

    static class CheckBoxRenderer
    implements TableCellRenderer {
        JCheckBox checkbox = new JCheckBox();

        CheckBoxRenderer() {
            if (OsVersion.IS_UNIX && !OsVersion.IS_OSX) {
                this.checkbox.setIcon(new LFIndependentIcon());
                this.checkbox.setDisabledIcon(new LFIndependentIcon());
                this.checkbox.setSelectedIcon(new LFIndependentIcon());
                this.checkbox.setDisabledSelectedIcon(new LFIndependentIcon());
            }
            this.checkbox.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.checkbox.setForeground(table.getSelectionForeground());
                this.checkbox.setBackground(table.getSelectionBackground());
            } else {
                this.checkbox.setForeground(table.getForeground());
                this.checkbox.setBackground(table.getBackground());
            }
            int state = (Integer)value;
            if (state == -2) {
                this.checkbox.setForeground(Color.GRAY);
            }
            if (state == -3) {
                this.checkbox.setForeground(Color.RED);
                this.checkbox.setSelected(true);
            }
            this.checkbox.setEnabled(state >= 0);
            this.checkbox.setSelected(value != null && Math.abs(state) == 1);
            return this.checkbox;
        }
    }

    public static class LFIndependentIcon
    implements Icon {
        ButtonModel buttonModel = null;

        protected int getControlSize() {
            return 13;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int x, int y) {
            ButtonModel model;
            this.buttonModel = model = ((JCheckBox)component).getModel();
            int controlSize = this.getControlSize();
            if (model.isPressed() && model.isArmed()) {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                if (model.isEnabled()) {
                    graphics.setColor(Color.green);
                } else {
                    graphics.setColor(Color.gray);
                }
                graphics.fillRect(x, y, controlSize - 1, controlSize - 1);
                this.drawPressedBorder(graphics, x, y, controlSize, controlSize, model);
            } else {
                this.drawBorder(graphics, x, y, controlSize, controlSize, model);
            }
            graphics.setColor(Color.green);
            if (model.isSelected()) {
                this.drawCheck(graphics, x, y);
            }
        }

        private void drawBorder(Graphics graphics, int x, int y, int width, int height, ButtonModel model) {
            graphics.translate(x, y);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            if (!model.isEnabled()) {
                graphics.setColor(new Color(0.4f, 0.4f, 0.4f));
            }
            graphics.drawRect(0, 0, width - 2, height - 2);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            if (!model.isEnabled()) {
                graphics.setColor(new Color(0.6f, 0.6f, 0.6f));
            }
            graphics.drawRect(1, 1, width - 2, height - 2);
            if (model.isEnabled()) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(new Color(0.8f, 0.8f, 0.8f));
            }
            graphics.fillRect(2, 2, width - 3, height - 3);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.drawLine(0, height - 1, 1, height - 2);
            graphics.drawLine(width - 1, 0, width - 2, 1);
            graphics.translate(-x, -y);
        }

        private void drawPressedBorder(Graphics graphics, int x, int y, int width, int height, ButtonModel model) {
            graphics.translate(x, y);
            this.drawBorder(graphics, 0, 0, width, height, model);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(1, 1, 1, height - 2);
            graphics.drawLine(1, 1, width - 2, 1);
            graphics.drawLine(2, 2, 2, height - 3);
            graphics.drawLine(2, 2, width - 3, 2);
            graphics.translate(-x, -y);
        }

        protected void drawCheck(Graphics graphics, int x, int y) {
            int controlSize = this.getControlSize();
            if (this.buttonModel != null) {
                if (this.buttonModel.isEnabled()) {
                    graphics.setColor(new Color(0.0f, 0.6f, 0.0f));
                } else {
                    graphics.setColor(new Color(0.1f, 0.1f, 0.1f));
                }
            }
            graphics.drawLine(x + (controlSize - 4), y + 2, x + (controlSize - 4) - 4, y + 2 + 4);
            graphics.drawLine(x + (controlSize - 4), y + 3, x + (controlSize - 4) - 4, y + 3 + 4);
            graphics.drawLine(x + (controlSize - 4), y + 4, x + (controlSize - 4) - 4, y + 4 + 4);
            graphics.drawLine(x + (controlSize - 4) - 4, y + 2 + 4, x + (controlSize - 4) - 4 - 2, y + 2 + 4 - 2);
            graphics.drawLine(x + (controlSize - 4) - 4, y + 3 + 4, x + (controlSize - 4) - 4 - 2, y + 3 + 4 - 2);
            graphics.drawLine(x + (controlSize - 4) - 4, y + 4 + 4, x + (controlSize - 4) - 4 - 2, y + 4 + 4 - 2);
        }

        @Override
        public int getIconWidth() {
            return this.getControlSize();
        }

        @Override
        public int getIconHeight() {
            return this.getControlSize();
        }
    }

    static class PacksPanelTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -9089892183236584242L;

        PacksPanelTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int state = (Integer)table.getModel().getValueAt(row, 0);
            if (state == -2) {
                renderer.setForeground(Color.GRAY);
                if (isSelected) {
                    renderer.setBackground(table.getSelectionBackground());
                } else {
                    renderer.setBackground(table.getBackground());
                }
            } else if (isSelected) {
                renderer.setForeground(table.getSelectionForeground());
                renderer.setBackground(table.getSelectionBackground());
            } else {
                renderer.setForeground(table.getForeground());
                renderer.setBackground(table.getBackground());
            }
            return renderer;
        }
    }
}

