/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.path;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.installer.base.InstallerFrame;
import com.izforge.izpack.installer.base.IzPanel;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.panels.path.PathSelectionPanel;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PathInputPanel
extends IzPanel
implements ActionListener {
    private static final long serialVersionUID = 3257566217698292531L;
    protected boolean mustExist = false;
    protected String[] existFiles = null;
    protected PathSelectionPanel pathSelectionPanel;
    protected String emptyTargetMsg = this.getI18nStringForClass("empty_target", "TargetPanel");
    protected String warnMsg = this.getI18nStringForClass("warn", "TargetPanel");
    protected static String defaultInstallDir = null;

    public PathInputPanel(InstallerFrame parent, GUIInstallData idata, ResourceManager resourceManager) {
        super(parent, idata, new IzPanelLayout(), resourceManager);
        String introText = this.getI18nStringForClass("extendedIntro", "PathInputPanel");
        if ((introText == null || introText.endsWith("extendedIntro") || introText.indexOf(36) > -1) && ((introText = this.getI18nStringForClass("intro", "PathInputPanel")) == null || introText.endsWith("intro"))) {
            introText = "";
        }
        this.add(this.createMultiLineLabel(introText));
        this.add(IzPanelLayout.createParagraphGap());
        this.add((Component)this.createLabel("info", "TargetPanel", "open", 2, true), "nextLine");
        this.pathSelectionPanel = new PathSelectionPanel(this, idata);
        this.add((Component)this.pathSelectionPanel, "nextLine");
        this.createLayoutBottom();
        this.getLayoutHelper().completeLayout();
    }

    public void createLayoutBottom() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.pathSelectionPanel.getPathInputField()) {
            this.parent.navigateNext();
        }
    }

    @Override
    public boolean isValidated() {
        String chosenPath = this.pathSelectionPanel.getPath();
        boolean ok = true;
        boolean modifyinstallation = Boolean.valueOf(this.installData.getVariable("modify.izpack.install"));
        if (modifyinstallation) {
            this.mustExist = true;
            File installationinformation = new File(String.valueOf(this.pathSelectionPanel.getPath()) + File.separator + ".installationinformation");
            if (!installationinformation.exists()) {
                this.emitError(this.installData.getLangpack().getString("installer.error"), this.installData.getLangpack().getString("PathInputPanel.required.forModificationInstallation"));
                return false;
            }
        }
        if (chosenPath.length() == 0) {
            if (this.isMustExist()) {
                this.emitError(this.installData.getLangpack().getString("installer.error"), this.installData.getLangpack().getString("PathInputPanel.required"));
                return false;
            }
            ok = this.emitWarning(this.installData.getLangpack().getString("installer.warning"), this.emptyTargetMsg);
        }
        if (!ok) {
            return ok;
        }
        if (chosenPath.startsWith("~")) {
            String home = System.getProperty("user.home");
            chosenPath = String.valueOf(home) + chosenPath.substring(1);
        }
        File path = new File(chosenPath).getAbsoluteFile();
        chosenPath = path.toString();
        this.pathSelectionPanel.setPath(chosenPath);
        if (this.isMustExist()) {
            if (!path.exists()) {
                this.emitError(this.installData.getLangpack().getString("installer.error"), this.installData.getLangpack().getString(this.getI18nStringForClass("required", "PathInputPanel")));
                return false;
            }
            if (!this.pathIsValid()) {
                this.emitError(this.installData.getLangpack().getString("installer.error"), this.installData.getLangpack().getString(this.getI18nStringForClass("notValid", "PathInputPanel")));
                return false;
            }
        } else {
            if (!this.isWriteable()) {
                this.emitError(this.installData.getLangpack().getString("installer.error"), this.getI18nStringForClass("notwritable", "TargetPanel"));
                return false;
            }
            if (path.exists()) {
                int res = this.askQuestion(this.installData.getLangpack().getString("installer.warning"), this.warnMsg, 37, 47);
                ok = res == 47;
            } else {
                String vStr = this.installData.getVariable("ShowCreateDirectoryMessage");
                if (vStr == null || Boolean.getBoolean(vStr)) {
                    ok = this.emitNotificationFeedback(String.valueOf(this.getI18nStringForClass("createdir", "TargetPanel")) + "\n" + chosenPath);
                }
            }
        }
        return ok;
    }

    protected boolean pathIsValid() {
        if (this.existFiles == null) {
            return true;
        }
        String[] stringArray = this.existFiles;
        int n = this.existFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String existFile = stringArray[n2];
            File path = new File(this.pathSelectionPanel.getPath(), existFile).getAbsoluteFile();
            if (!path.exists()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isMustExist() {
        return this.mustExist;
    }

    public void setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
    }

    public String[] getExistFiles() {
        return this.existFiles;
    }

    public void setExistFiles(String[] strings) {
        this.existFiles = strings;
    }

    public void loadDefaultInstallDir() {
        defaultInstallDir = PathInputPanel.loadDefaultInstallDir(this.resourceManager, this.variableSubstitutor, this.installData);
    }

    public static String loadDefaultInstallDir(ResourceManager resourceManager, VariableSubstitutor variableSubstitutor, AutomatedInstallData installData) {
        String defaultInstallDir = PathInputPanel.getDefaultInstallDir();
        if (defaultInstallDir != null) {
            return defaultInstallDir;
        }
        BufferedReader br = null;
        try {
            try {
                InputStream in = null;
                String os = System.getProperty("os.name");
                os = os.replace(' ', '_');
                os = os.toLowerCase();
                try {
                    in = resourceManager.getInputStream("TargetPanel.dir.".concat(os));
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
                if (in == null) {
                    if (OsVersion.IS_WINDOWS) {
                        try {
                            in = resourceManager.getInputStream("TargetPanel.dir.windows");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {}
                    } else if (OsVersion.IS_OSX) {
                        try {
                            in = resourceManager.getInputStream("TargetPanel.dir.macosx");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {}
                    } else {
                        try {
                            in = resourceManager.getInputStream("TargetPanel.dir.unix");
                        }
                        catch (ResourceNotFoundException resourceNotFoundException) {
                            // empty catch block
                        }
                    }
                }
                if (in == null) {
                    try {
                        in = resourceManager.getInputStream("TargetPanel.dir");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    String line;
                    InputStreamReader isr = new InputStreamReader(in);
                    br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        if (!"".equals(line = line.trim())) break;
                    }
                    defaultInstallDir = line;
                    defaultInstallDir = variableSubstitutor.substitute(defaultInstallDir);
                } else {
                    defaultInstallDir = installData.getDefaultInstallPath();
                    if (defaultInstallDir == null) {
                        defaultInstallDir = System.getProperty("user.dir");
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                defaultInstallDir = null;
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException iOException) {}
        }
        return defaultInstallDir;
    }

    public boolean isWriteable() {
        File existParent = IoHelper.existingParent(new File(this.pathSelectionPanel.getPath()));
        if (existParent == null) {
            return false;
        }
        if (OsVersion.IS_WINDOWS) {
            try {
                File tmpFile = File.createTempFile("izWrTe", ".tmp", existParent);
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                Debug.trace(e.toString());
                return false;
            }
            return true;
        }
        return existParent.canWrite();
    }

    public static String getDefaultInstallDir() {
        return defaultInstallDir;
    }

    public static void setDefaultInstallDir(String defaultInstallDir) {
        PathInputPanel.defaultInstallDir = defaultInstallDir;
    }
}

