/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.target;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.installer.console.PanelConsole;
import com.izforge.izpack.installer.console.PanelConsoleHelper;
import com.izforge.izpack.panels.path.PathInputPanel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Properties;

public class TargetPanelConsoleHelper
extends PanelConsoleHelper
implements PanelConsole {
    @Override
    public boolean runGeneratePropertiesFile(AutomatedInstallData installData, PrintWriter printWriter) {
        printWriter.println("INSTALL_PATH=");
        return true;
    }

    @Override
    public boolean runConsoleFromProperties(AutomatedInstallData installData, Properties p) {
        String strTargetPath = p.getProperty("INSTALL_PATH");
        if (strTargetPath == null || "".equals(strTargetPath.trim())) {
            System.err.println("Missing mandatory target path!");
            return false;
        }
        try {
            strTargetPath = installData.getVariableSubstitutor().substitute(strTargetPath);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        installData.setInstallPath(strTargetPath);
        return true;
    }

    @Override
    public boolean runConsole(AutomatedInstallData idata) {
        ResourceManager resourceManager = ResourceManager.getInstance();
        String strDefaultPath = PathInputPanel.loadDefaultInstallDir(resourceManager, idata.getVariableSubstitutor(), idata);
        String strTargetPath = "";
        System.out.println("Select target path [" + strDefaultPath + "] ");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        try {
            String strIn = reader.readLine();
            strTargetPath = !strIn.trim().equals("") ? strIn : strDefaultPath;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            strTargetPath = idata.getVariableSubstitutor().substitute(strTargetPath);
        }
        catch (Exception e) {
            // empty catch block
        }
        idata.setInstallPath(strTargetPath);
        int i = this.askEndOfConsolePanel();
        if (i == 1) {
            return true;
        }
        if (i == 2) {
            return false;
        }
        return this.runConsole(idata);
    }
}

