/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.validator;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.panels.userinput.PasswordGroup;
import com.izforge.izpack.panels.userinput.processorclient.ProcessingClient;
import com.izforge.izpack.panels.userinput.validator.Validator;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public class PasswordKeystoreValidator
implements Validator {
    private VariableSubstitutor variableSubstitutor;

    public PasswordKeystoreValidator(VariableSubstitutor variableSubstitutor) {
        this.variableSubstitutor = variableSubstitutor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validate(ProcessingClient client) {
        boolean returnValue = false;
        String keystorePassword = null;
        String keystoreFile = null;
        String keystoreType = "JKS";
        String skipValidation = null;
        String alias = null;
        String aliasPassword = null;
        Map<String, String> params = this.getParams(client);
        try {
            if (params != null) {
                skipValidation = params.get("skipValidation");
                System.out.println("skipValidation = " + skipValidation);
                if (skipValidation != null && skipValidation.equalsIgnoreCase("true")) {
                    System.out.println("Not validating keystore");
                    return true;
                }
                keystorePassword = params.get("keystorePassword");
                if (keystorePassword == null) {
                    keystorePassword = this.getPassword(client);
                    System.out.println("keystorePassword parameter null, using validator password for keystore");
                } else if (keystorePassword.equalsIgnoreCase("")) {
                    keystorePassword = this.getPassword(client);
                    System.out.println("keystorePassword parameter empty, using validator password for keystore");
                }
                aliasPassword = params.get("aliasPassword");
                if (aliasPassword == null) {
                    aliasPassword = this.getPassword(client);
                    System.out.println("aliasPassword parameter null, using validator password for key");
                } else if (aliasPassword.equalsIgnoreCase("")) {
                    aliasPassword = this.getPassword(client);
                    System.out.println("aliasPassword parameter empty, using validator password for key");
                }
                keystoreType = params.get("keystoreType");
                if (keystoreType == null) {
                    keystoreType = "JKS";
                }
                System.out.println("keystoreType parameter null, using default of JKS");
            } else if (keystoreType.equalsIgnoreCase("")) {
                keystoreType = "JKS";
                System.out.println("keystoreType parameter empty, using default of JKS");
            }
            keystoreFile = params.get("keystoreFile");
            if (keystoreFile == null) {
                System.out.println("keystoreFile param not provided");
                return returnValue;
            }
            System.out.println("Attempting to open keystore: " + keystoreFile);
            KeyStore keyStore = PasswordKeystoreValidator.getKeyStore(keystoreFile, keystoreType, keystorePassword.toCharArray());
            if (keyStore == null) return returnValue;
            returnValue = true;
            System.out.println("keystore password validated");
            alias = params.get("keystoreAlias");
            if (alias == null) return returnValue;
            returnValue = keyStore.containsAlias(alias);
            if (!returnValue) {
                System.out.println("keystore alias '" + alias + "' not found");
                return returnValue;
            }
            System.out.println("keystore alias '" + alias + "' found, trying to retrieve");
            try {
                keyStore.getKey(alias, aliasPassword.toCharArray());
                System.out.println("keystore alias '" + alias + "' validated");
                return returnValue;
            }
            catch (Exception e) {
                System.out.println("keystore alias validation failed: " + e);
                return false;
            }
        }
        catch (Exception e) {
            System.out.println("validate() Failed: " + e);
        }
        return returnValue;
    }

    private Map<String, String> getParams(ProcessingClient client) {
        HashMap<String, String> returnValue = null;
        PasswordGroup group = null;
        try {
            group = (PasswordGroup)client;
            if (group.hasParams()) {
                Map<String, String> params = group.getValidatorParams();
                returnValue = new HashMap<String, String>();
                for (String key : params.keySet()) {
                    String value = this.variableSubstitutor.substitute(params.get(key));
                    returnValue.put(key, value);
                }
            }
        }
        catch (Exception e) {
            System.out.println("getParams() Failed: " + e);
        }
        return returnValue;
    }

    private String getPassword(ProcessingClient client) {
        return client.getFieldContents(0);
    }

    public static KeyStore getKeyStore(String fileName, String type, char[] password) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(new FileInputStream(fileName), password);
        }
        catch (Exception e) {
            System.out.println("getKeyStore() Failed: " + e);
            keyStore = null;
        }
        return keyStore;
    }
}

