/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.MonitorInputStream;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FileExecutor {
    private static final String JAR_FILE_SUFFIX = ".jar";
    private Collection<ExecutableFile> files;

    private boolean stopThread(Thread t, MonitorInputStream monitorInputStream) {
        monitorInputStream.doStop();
        long softTimeout = 1000L;
        try {
            t.join(softTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!t.isAlive()) {
            return true;
        }
        t.interrupt();
        long hardTimeout = 1000L;
        try {
            t.join(hardTimeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !t.isAlive();
    }

    public FileExecutor(Collection<ExecutableFile> files) {
        this.files = files;
    }

    public FileExecutor() {
        this.files = null;
    }

    public static String getExecOutput(String[] aCommandLine) {
        return FileExecutor.getExecOutput(aCommandLine, null, false);
    }

    public static String getExecOutput(String[] aCommandLine, String dir) {
        return FileExecutor.getExecOutput(aCommandLine, dir, false);
    }

    public static String getExecOutput(String[] aCommandLine, boolean forceToGetStdOut) {
        return FileExecutor.getExecOutput(aCommandLine, null, forceToGetStdOut);
    }

    public static String getExecOutput(String[] aCommandLine, String dir, boolean forceToGetStdOut) {
        FileExecutor fileExecutor = new FileExecutor();
        String[] execOut = new String[2];
        int execResult = fileExecutor.executeCommand(aCommandLine, execOut, dir);
        if (execResult == 0) {
            return execOut[0];
        }
        if (forceToGetStdOut) {
            return execOut[0];
        }
        return execOut[1];
    }

    public int executeCommand(String[] params, String[] output) {
        return this.executeCommand(params, output, null);
    }

    public int executeCommand(String[] params, String[] output, String dir) {
        StringBuffer retval = new StringBuffer();
        retval.append("executeCommand\n");
        if (params != null) {
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                retval.append("\tparams: ").append(param);
                retval.append("\n");
                ++n2;
            }
        }
        if (dir != null) {
            retval.append("working dir: " + dir + "\n");
        }
        Process process = null;
        MonitorInputStream outMonitor = null;
        MonitorInputStream errMonitor = null;
        Thread outMonitorThread = null;
        Thread errMonitorThread = null;
        int exitStatus = -1;
        Debug.trace(retval);
        try {
            try {
                if (params[0].matches("^.*[\\\\/]+[\\.]+[\\\\/]+.*$")) {
                    params[0] = new File(params[0]).getCanonicalPath();
                }
                if (dir != null) {
                    if (dir.matches("^.*[\\\\/]+[\\.]+[\\\\/]+.*$")) {
                        dir = new File(dir).getCanonicalPath();
                    }
                    process = Runtime.getRuntime().exec(params, null, new File(dir));
                } else {
                    process = Runtime.getRuntime().exec(params);
                }
                boolean isConsole = false;
                if (isConsole) {
                    Console console = new Console(process);
                    output[0] = console.getOutputData();
                    output[1] = console.getErrorData();
                    exitStatus = process.exitValue();
                } else {
                    StringWriter outWriter = new StringWriter();
                    StringWriter errWriter = new StringWriter();
                    InputStreamReader outStreamReader = new InputStreamReader(process.getInputStream());
                    InputStreamReader errStreamReader = new InputStreamReader(process.getErrorStream());
                    outMonitor = new MonitorInputStream(outStreamReader, outWriter);
                    errMonitor = new MonitorInputStream(errStreamReader, errWriter);
                    outMonitorThread = new Thread(outMonitor);
                    errMonitorThread = new Thread(errMonitor);
                    outMonitorThread.setDaemon(true);
                    errMonitorThread.setDaemon(true);
                    outMonitorThread.start();
                    errMonitorThread.start();
                    exitStatus = process.waitFor();
                    outMonitorThread.join();
                    errMonitorThread.join();
                    output[0] = outWriter.toString();
                    Debug.trace("stdout:");
                    Debug.trace(output[0]);
                    output[1] = errWriter.toString();
                    Debug.trace("stderr:");
                    Debug.trace(output[1]);
                }
                Debug.trace("exit status: " + Integer.toString(exitStatus));
            }
            catch (InterruptedException e) {
                if (Debug.tracing()) {
                    e.printStackTrace(System.err);
                }
                this.stopThread(outMonitorThread, outMonitor);
                this.stopThread(errMonitorThread, errMonitor);
                output[0] = "";
                output[1] = String.valueOf(e.getMessage()) + "\n";
                if (process != null) {
                    process.destroy();
                }
            }
            catch (IOException e) {
                if (Debug.tracing()) {
                    e.printStackTrace(System.err);
                }
                output[0] = "";
                output[1] = String.valueOf(e.getMessage()) + "\n";
                if (process != null) {
                    process.destroy();
                }
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return exitStatus;
    }

    public int executeFiles(int currentStage, AbstractUIHandler handler) {
        int exitStatus = 0;
        String[] output = new String[2];
        Iterator<ExecutableFile> efileIterator = this.files.iterator();
        while (exitStatus == 0 && efileIterator.hasNext()) {
            ExecutableFile efile = efileIterator.next();
            boolean deleteAfterwards = !efile.keepFile;
            File file = new File(efile.path);
            Debug.trace("handling executable file " + efile);
            if (!OsConstraintHelper.oneMatchesCurrentSystem(efile.osList)) continue;
            if (efile.type == 0 && currentStage != 2 && OsVersion.IS_UNIX) {
                Debug.trace("making file executable (setting executable flag)");
                if (!file.canExecute()) {
                    try {
                        file.setExecutable(true, false);
                    }
                    catch (SecurityException se) {
                        handler.emitWarning("Cannot make file executable", file.getPath());
                        continue;
                    }
                }
            }
            if (exitStatus == 0 && (currentStage == 0 && efile.executionStage == 0 || currentStage == 2 && efile.executionStage == 2)) {
                ArrayList<String> paramList = new ArrayList<String>();
                if (efile.type == 0) {
                    paramList.add(file.toString());
                } else if (1 == efile.type && efile.mainClass == null) {
                    paramList.add(String.valueOf(System.getProperty("java.home")) + "/bin/java");
                    paramList.add("-jar");
                    paramList.add(file.toString());
                } else if (1 == efile.type && efile.mainClass != null) {
                    paramList.add(String.valueOf(System.getProperty("java.home")) + "/bin/java");
                    paramList.add("-cp");
                    try {
                        paramList.add(this.buildClassPath(file.toString()));
                    }
                    catch (Exception e) {
                        exitStatus = -1;
                        Debug.error(e);
                    }
                    paramList.add(efile.mainClass);
                }
                if (efile.argList != null && !efile.argList.isEmpty()) {
                    paramList.addAll(efile.argList);
                }
                String[] params = new String[paramList.size()];
                int i = 0;
                while (i < paramList.size()) {
                    params[i] = (String)paramList.get(i);
                    ++i;
                }
                exitStatus = this.executeCommand(params, output);
                if (exitStatus != 0) {
                    deleteAfterwards = false;
                    String message = String.valueOf(output[0]) + "\n" + output[1];
                    if (message.length() == 1) {
                        message = "Failed to execute " + file.toString() + ".";
                    }
                    if (efile.onFailure == 0) {
                        handler.emitErrorAndBlockNext("File execution returned " + exitStatus, message);
                    } else if (efile.onFailure == 1) {
                        handler.emitWarning("File execution returned " + exitStatus, message);
                        exitStatus = 0;
                    } else if (efile.onFailure == 3) {
                        exitStatus = 0;
                    } else if (handler.askQuestion("Execution Failed", String.valueOf(message) + "\nContinue Installation?", 37) == 47) {
                        exitStatus = 0;
                    }
                }
            }
            if (efile.executionStage != 0 || !deleteAfterwards || !file.canWrite()) continue;
            file.delete();
        }
        return exitStatus;
    }

    private String buildClassPath(String targetFile) throws Exception {
        String[] rawJars;
        StringBuffer classPath = new StringBuffer();
        ArrayList<String> jars = new ArrayList<String>();
        String rawClassPath = targetFile.replaceAll(":\\\\", "#DRIVE#").replaceAll(";", "#").replaceAll(":", "#").replace("#DRIVE#", ":\\");
        String[] stringArray = rawJars = rawClassPath.split("#");
        int n = rawJars.length;
        int n2 = 0;
        while (n2 < n) {
            String[] subDirJars;
            String rawJar = stringArray[n2];
            File file = new File(rawJar);
            jars.add(rawJar);
            if (file.isDirectory() && (subDirJars = FileUtil.getFileNames(rawJar, new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(FileExecutor.JAR_FILE_SUFFIX);
                }
            })) != null) {
                String[] stringArray2 = subDirJars;
                int n3 = subDirJars.length;
                int n4 = 0;
                while (n4 < n3) {
                    String subDirJar = stringArray2[n4];
                    jars.add(String.valueOf(rawJar) + File.separator + subDirJar);
                    ++n4;
                }
            }
            ++n2;
        }
        Iterator iter = jars.iterator();
        if (iter.hasNext()) {
            classPath.append((String)iter.next());
        }
        while (iter.hasNext()) {
            classPath.append(File.pathSeparatorChar).append((String)iter.next());
        }
        return classPath.toString();
    }
}

