/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Librarian;
import com.izforge.izpack.util.OsVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Housekeeper {
    private static Housekeeper me = null;
    private List<CleanupClient> cleanupClients = new ArrayList<CleanupClient>();

    private Housekeeper() {
    }

    public static Housekeeper getInstance() {
        if (me == null) {
            me = new Housekeeper();
        }
        return me;
    }

    public void registerForCleanup(CleanupClient client) {
        if (client instanceof Librarian) {
            this.cleanupClients.add(0, client);
        } else {
            this.cleanupClients.add(client);
        }
    }

    public void shutDown(int exitCode) {
        this.shutDown(exitCode, false);
    }

    public void shutDown(int exitCode, boolean reboot) {
        int i = this.cleanupClients.size() - 1;
        while (i >= 0) {
            try {
                this.cleanupClients.get(i).cleanUp();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            --i;
        }
        if (reboot) {
            try {
                this.systemReboot();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.exit(exitCode);
    }

    private void systemReboot() throws IOException {
        int waitseconds = 2;
        if (OsVersion.IS_UNIX) {
            Runtime.getRuntime().exec("sudo /sbin/shutdown -r -t 2 now");
        } else if (OsVersion.IS_WINDOWS) {
            Runtime.getRuntime().exec("shutdown /r /f /t 2");
        } else {
            throw new IOException("Reboot not implemented for your OS");
        }
    }
}

