/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.OsVersion;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class LibraryRemover {
    private static final String[] SANDBOX_CONTENT = new String[]{"com/izforge/izpack/util/LibraryRemover.class"};
    private static final String BASE_KEY = "lib.rem.base";
    private static final String PHASE_KEY = "self.mod.phase";
    private static final String JAVA_HOME = System.getProperty("java.home");
    private static final String PREFIX = "InstallRemover";
    private int phase = 0;
    private File logFile = null;
    private File sandbox = null;
    private File specFile = null;
    private SimpleDateFormat isoPoint = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private Date date = new Date();
    PrintStream log = null;

    private LibraryRemover(int phase) throws IOException {
        this.phase = phase;
        if (phase == 1) {
            this.initJavaExec();
        } else {
            this.logFile = new File(String.valueOf(System.getProperty(BASE_KEY)) + ".log");
            this.specFile = new File(String.valueOf(System.getProperty(BASE_KEY)) + ".spec");
            this.sandbox = new File(String.valueOf(System.getProperty(BASE_KEY)) + ".d");
        }
    }

    public static void invoke(List<String> temporaryFileNames) throws IOException {
        LibraryRemover self = new LibraryRemover(1);
        self.invoke1(temporaryFileNames);
    }

    private void initJavaExec() throws IOException {
        try {
            Process process = Runtime.getRuntime().exec(LibraryRemover.javaCommand());
            new StreamProxy(process.getErrorStream(), "err").start();
            new StreamProxy(process.getInputStream(), "out").start();
            process.getOutputStream().close();
            process.waitFor();
        }
        catch (InterruptedException ie) {
            throw new IOException("Unable to create a java subprocess");
        }
    }

    private void invoke1(List<String> temporaryFileNames) throws IOException {
        while (true) {
            this.logFile = File.createTempFile(PREFIX, ".log");
            String canonicalPath = this.logFile.getCanonicalPath();
            this.specFile = new File(String.valueOf(canonicalPath.substring(0, canonicalPath.length() - 4)) + ".spec");
            this.sandbox = new File(String.valueOf(canonicalPath.substring(0, canonicalPath.length() - 4)) + ".d");
            if (!this.sandbox.exists()) break;
            this.logFile.delete();
        }
        if (!this.sandbox.mkdir()) {
            throw new RuntimeException("Failed to create temp dir: " + this.sandbox);
        }
        this.sandbox = this.sandbox.getCanonicalFile();
        this.logFile = this.logFile.getCanonicalFile();
        BufferedOutputStream out = null;
        InputStream in = null;
        byte[] buf = new byte[5120];
        int extracted = 0;
        String[] stringArray = SANDBOX_CONTENT;
        int n = SANDBOX_CONTENT.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String aSANDBOX_CONTENT = stringArray[n2];
            in = this.getClass().getResourceAsStream("/" + aSANDBOX_CONTENT);
            File outFile = new File(this.sandbox, aSANDBOX_CONTENT);
            File parent = outFile.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            while ((n3 = in.read(buf, 0, buf.length)) > 0) {
                ((OutputStream)out).write(buf, 0, n3);
            }
            ((OutputStream)out).close();
            ++extracted;
            ++n2;
        }
        out = new BufferedOutputStream(new FileOutputStream(this.specFile));
        BufferedWriter specWriter = new BufferedWriter(new OutputStreamWriter(out));
        Iterator<String> iter = temporaryFileNames.iterator();
        while (iter.hasNext()) {
            specWriter.write(iter.next());
            if (!iter.hasNext()) continue;
            specWriter.newLine();
        }
        specWriter.flush();
        ((OutputStream)out).close();
        this.spawn(2);
        this.log("library cleanup done");
    }

    private ArrayList<File> getFilesList() throws Exception {
        TreeSet files = new TreeSet(Collections.reverseOrder());
        FileInputStream in = new FileInputStream(this.specFile);
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        String read = reader.readLine();
        while (read != null) {
            files.add(new File(read));
            read = reader.readLine();
        }
        ((InputStream)in).close();
        return new ArrayList<File>(files);
    }

    private void invoke2() {
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ArrayList<File> files = this.getFilesList();
            this.log("deleteing temporary dlls/shls");
            for (File file : files) {
                file.delete();
                if (file.exists()) {
                    this.log("    deleting of " + file.getCanonicalPath() + " failed!!!");
                    continue;
                }
                this.log("    " + file.getCanonicalPath());
            }
            this.log("deleteing sandbox");
            LibraryRemover.deleteTree(this.sandbox);
            this.specFile.delete();
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    private Process spawn(int nextPhase) throws IOException {
        String base = this.logFile.getAbsolutePath();
        base = base.substring(0, base.length() - 4);
        String[] javaCmd = new String[]{LibraryRemover.javaCommand(), "-classpath", this.sandbox.getAbsolutePath(), "-Dlib.rem.base=" + base, "-Dself.mod.phase=" + nextPhase, this.getClass().getName()};
        StringBuffer sb = new StringBuffer("Spawning phase ");
        sb.append(nextPhase).append(": ");
        String[] stringArray = javaCmd;
        int n = javaCmd.length;
        int n2 = 0;
        while (n2 < n) {
            String aJavaCmd = stringArray[n2];
            sb.append("\n\t").append(aJavaCmd);
            ++n2;
        }
        this.log(sb.toString());
        return Runtime.getRuntime().exec(javaCmd, null, null);
    }

    public static boolean deleteTree(File file) {
        if (file.isDirectory()) {
            File[] files;
            File[] fileArray = files = file.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file1 = fileArray[n2];
                LibraryRemover.deleteTree(file1);
                ++n2;
            }
        }
        return file.delete();
    }

    private static String addExtension(String command) {
        return String.valueOf(command) + (OsVersion.IS_WINDOWS || OsVersion.IS_OS2 ? ".exe" : "");
    }

    private static String javaCommand() {
        String executable = LibraryRemover.addExtension("java");
        String dir = new File(String.valueOf(JAVA_HOME) + "/bin").getAbsolutePath();
        File jExecutable = new File(dir, executable);
        if (!jExecutable.exists()) {
            return executable;
        }
        return jExecutable.getAbsolutePath();
    }

    public static void main(String[] args) {
        try {
            LibraryRemover librianRemover = new LibraryRemover(2);
            librianRemover.invoke2();
        }
        catch (IOException ioe) {
            System.err.println("Error invoking a secondary phase");
            System.err.println("Note that this program is only intended as a secondary process");
            ioe.printStackTrace();
        }
    }

    private PrintStream checkLog() {
        try {
            if (this.log == null) {
                this.log = new PrintStream(new FileOutputStream(this.logFile.toString(), true));
            }
        }
        catch (IOException x) {
            System.err.println("Phase " + this.phase + " log err: " + x.getMessage());
            x.printStackTrace();
        }
        this.date.setTime(System.currentTimeMillis());
        return this.log;
    }

    private void log(Throwable t) {
        if (this.checkLog() != null) {
            this.log.println(String.valueOf(this.isoPoint.format(this.date)) + " Phase " + this.phase + ": " + t.getMessage());
            t.printStackTrace(this.log);
        }
    }

    private void log(String msg) {
        if (this.checkLog() != null) {
            this.log.println(String.valueOf(this.isoPoint.format(this.date)) + " Phase " + this.phase + ": " + msg);
        }
    }

    public static class StreamProxy
    extends Thread {
        InputStream in;
        String name;
        OutputStream out;

        public StreamProxy(InputStream in, String name) {
            this(in, name, null);
        }

        public StreamProxy(InputStream in, String name, OutputStream out) {
            this.in = in;
            this.name = name;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                String line;
                PrintWriter printWriter = null;
                if (this.out != null) {
                    printWriter = new PrintWriter(this.out);
                }
                BufferedReader br = new BufferedReader(new InputStreamReader(this.in));
                while ((line = br.readLine()) != null) {
                    if (printWriter == null) continue;
                    printWriter.println(line);
                }
                if (printWriter != null) {
                    printWriter.flush();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

