/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.util.CleanupClient;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.file.FileUtils;
import java.io.File;
import java.io.IOException;

public class TemporaryDirectory
implements CleanupClient {
    private File tempdir;
    private final AutomatedInstallData installData;
    private final Info.TempDir tempDirDescription;
    private boolean deleteOnExit = false;

    public TemporaryDirectory(Info.TempDir tempDirDescription, AutomatedInstallData installData) {
        if (tempDirDescription == null) {
            throw new IllegalArgumentException("Unable to create a temporary directory, the temp directory description may not be null.");
        }
        if (installData == null) {
            throw new IllegalArgumentException("Unable to create a temporary directory, the install data may not be null.");
        }
        this.installData = installData;
        this.tempDirDescription = tempDirDescription;
    }

    public void create() throws IOException {
        try {
            this.tempdir = File.createTempFile(this.tempDirDescription.getPrefix(), this.tempDirDescription.getSuffix());
            this.tempdir.delete();
            this.tempdir.mkdir();
        }
        catch (IOException e) {
            Debug.error("Unable to create temporary directory for install. IOException: ");
            Debug.error(e);
            throw e;
        }
        this.installData.setVariable(this.tempDirDescription.getVariableName(), this.tempdir.getAbsolutePath());
        Housekeeper.getInstance().registerForCleanup(this);
    }

    public void deleteOnExit() {
        this.deleteOnExit = true;
    }

    @Override
    public void cleanUp() {
        if (this.tempdir != null) {
            if (this.deleteOnExit) {
                if (!FileUtils.deleteRecursively(this.tempdir)) {
                    Debug.error("Failed to properly clean up files in " + this.tempdir.getAbsolutePath() + " manual clean up may be required.");
                }
            } else {
                Debug.log("Temporary directory has not been cleaned up. Files have been left in: " + this.tempdir.getAbsolutePath());
            }
        } else {
            Debug.log("TemporaryDirectory registered for cleanup but there is no temp directory to clean up.");
        }
    }
}

