/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.config;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.config.ConfigurableTask;
import com.izforge.izpack.util.file.DirectoryScanner;
import com.izforge.izpack.util.file.types.FileSet;
import com.izforge.izpack.util.xmlmerge.AbstractXmlMergeException;
import com.izforge.izpack.util.xmlmerge.ConfigurationException;
import com.izforge.izpack.util.xmlmerge.config.ConfigurableXmlMerge;
import com.izforge.izpack.util.xmlmerge.config.PropertyXPathConfigurer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class SingleXmlFileMergeTask
implements ConfigurableTask {
    protected File origfile;
    protected File patchfile;
    protected File tofile;
    protected File conffile;
    protected boolean cleanup;
    protected Properties confProps = new Properties();
    List<FileSet> filesets = new ArrayList<FileSet>();

    public void setOriginalFile(File origfile) {
        this.origfile = origfile;
    }

    public void setPatchFile(File patchfile) {
        this.patchfile = patchfile;
    }

    public void setToFile(File tofile) {
        this.tofile = tofile;
    }

    public void setConfigFile(File confFile) {
        this.conffile = confFile;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public void addFileSet(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void addProperty(String key, String value) {
        this.confProps.setProperty(key, value);
    }

    public void validate() throws Exception {
        if (this.tofile == null) {
            throw new Exception("XML merge output file not set");
        }
        if (this.filesets.isEmpty() && this.patchfile == null) {
            throw new Exception("No XML merge patch files given at all");
        }
        if (this.origfile == null) {
            throw new Exception("No XML merge patch files given at all");
        }
        if (!this.confProps.isEmpty() && this.conffile != null) {
            throw new Exception("Using both XML merge configuration file and explicit merge properties not allowed");
        }
    }

    @Override
    public void execute() throws Exception {
        ConfigurableXmlMerge xmlMerge;
        this.validate();
        LinkedList<File> filesToMerge = new LinkedList<File>();
        if (this.origfile != null) {
            if (!this.origfile.exists()) {
                Debug.log("XML merge skipped, target file " + this.origfile + " not found");
                return;
            }
        } else {
            Debug.log("XML merge skipped, target file not defined");
            return;
        }
        filesToMerge.add(this.origfile);
        if (this.patchfile != null && this.patchfile.exists()) {
            filesToMerge.add(this.patchfile);
        }
        for (FileSet fs : this.filesets) {
            String[] includedFiles;
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] stringArray = includedFiles = ds.getIncludedFiles();
            int n = includedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String includedFile = stringArray[n2];
                filesToMerge.add(new File(ds.getBasedir(), includedFile));
                ++n2;
            }
        }
        if (filesToMerge.size() < 2) {
            Debug.log("XML merge skipped, not enough XML input files to merge");
            return;
        }
        if (this.conffile != null) {
            FileInputStream configIn = null;
            try {
                try {
                    configIn = new FileInputStream(this.conffile);
                    this.confProps.load(configIn);
                }
                catch (IOException e) {
                    throw new Exception(e);
                }
            }
            finally {
                if (configIn != null) {
                    try {
                        ((InputStream)configIn).close();
                    }
                    catch (IOException e) {
                        Debug.log("Error closing file '" + this.conffile + "': " + e.getMessage());
                    }
                }
            }
        }
        try {
            xmlMerge = new ConfigurableXmlMerge(new PropertyXPathConfigurer(this.confProps));
        }
        catch (ConfigurationException e) {
            throw new Exception(e);
        }
        try {
            xmlMerge.merge(filesToMerge.toArray(new File[filesToMerge.size()]), this.tofile);
        }
        catch (AbstractXmlMergeException e) {
            throw new Exception(e);
        }
        if (this.cleanup) {
            for (File file : filesToMerge) {
                if (!file.exists() || file.equals(this.tofile) || file.delete()) continue;
                Debug.log("File " + file + " could not be cleant up");
            }
        }
    }
}

