/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.file.DirectoryScanner;
import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.FlatFileNameMapper;
import com.izforge.izpack.util.file.IdentityMapper;
import com.izforge.izpack.util.file.SourceFileScanner;
import com.izforge.izpack.util.file.types.FileSet;
import com.izforge.izpack.util.file.types.Mapper;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FileCopyTask {
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector<FileSet> filesets = new Vector();
    private boolean enableMultipleMappings = false;
    protected boolean preserveLastModified = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected boolean includeEmpty = true;
    protected boolean failonerror = true;
    protected Hashtable<String, String[]> fileCopyMap = new Hashtable();
    protected Hashtable<String, String[]> dirCopyMap = new Hashtable();
    protected Hashtable<File, File> completeDirMap = new Hashtable();
    protected Mapper mapperElement = null;
    protected FileUtils fileUtils = FileUtils.getFileUtils();
    private long granularity = this.fileUtils.getFileTimestampGranularity();

    protected FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setToFile(File destFile) {
        this.destFile = destFile;
    }

    public void setToDir(File destDir) {
        this.destDir = destDir;
    }

    public void setPreserveLastModified(boolean preserve) {
        this.preserveLastModified = preserve;
    }

    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }

    public void setOverwrite(boolean overwrite) {
        this.forceOverwrite = overwrite;
    }

    public void setFlatten(boolean flatten) {
        this.flatten = flatten;
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
    }

    public void setEnableMultipleMappings(boolean enableMultipleMappings) {
        this.enableMultipleMappings = enableMultipleMappings;
    }

    public boolean isEnableMultipleMapping() {
        return this.enableMultipleMappings;
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void addFileSet(FileSet set) {
        this.filesets.addElement(set);
    }

    public Mapper createMapper() throws Exception {
        if (this.mapperElement != null) {
            throw new Exception("Cannot define more than one mapper");
        }
        this.mapperElement = new Mapper();
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) throws Exception {
        this.createMapper().add(fileNameMapper);
    }

    public void setGranularity(long granularity) {
        this.granularity = granularity;
    }

    public void execute() throws Exception {
        block22: {
            File savedFile = this.file;
            File savedDestFile = this.destFile;
            File savedDestDir = this.destDir;
            FileSet savedFileSet = null;
            if (this.file == null && this.destFile != null && this.filesets.size() == 1) {
                savedFileSet = this.filesets.elementAt(0);
            }
            this.validateAttributes();
            try {
                if (this.file != null) {
                    if (this.file.exists()) {
                        if (this.destFile == null) {
                            this.destFile = new File(this.destDir, this.file.getName());
                        }
                        if (this.forceOverwrite || !this.destFile.exists() || this.file.lastModified() - this.granularity > this.destFile.lastModified()) {
                            this.fileCopyMap.put(this.file.getAbsolutePath(), new String[]{this.destFile.getAbsolutePath()});
                        } else {
                            Debug.log(this.file + " omitted as " + this.destFile + " is up to date.");
                        }
                    } else {
                        String message = "Warning: Could not find file " + this.file.getAbsolutePath() + " to copy.";
                        if (!this.failonerror) {
                            Debug.log(message);
                        } else {
                            throw new Exception(message);
                        }
                    }
                }
                int i = 0;
                while (i < this.filesets.size()) {
                    block21: {
                        boolean isEverythingIncluded;
                        FileSet fs = this.filesets.elementAt(i);
                        DirectoryScanner ds = null;
                        try {
                            ds = fs.getDirectoryScanner();
                        }
                        catch (Exception e) {
                            if (this.failonerror || !e.getMessage().endsWith(" not found.")) {
                                throw e;
                            }
                            Debug.log("Warning: " + e.getMessage());
                            break block21;
                        }
                        File fromDir = fs.getDir();
                        String[] srcFiles = ds.getIncludedFiles();
                        String[] srcDirs = ds.getIncludedDirectories();
                        boolean bl = isEverythingIncluded = ds.isEverythingIncluded() && !fs.hasSelectors() && !fs.hasPatterns();
                        if (isEverythingIncluded && !this.flatten && this.mapperElement == null) {
                            this.completeDirMap.put(fromDir, this.destDir);
                        }
                        this.scan(fromDir, this.destDir, srcFiles, srcDirs);
                    }
                    ++i;
                }
                try {
                    this.doFileOperations();
                }
                catch (Exception e) {
                    if (!this.failonerror) {
                        System.err.println("Warning: " + e.getMessage());
                        break block22;
                    }
                    throw e;
                }
            }
            finally {
                this.file = savedFile;
                this.destFile = savedDestFile;
                this.destDir = savedDestDir;
                if (savedFileSet != null) {
                    this.filesets.insertElementAt(savedFileSet, 0);
                }
                this.fileCopyMap.clear();
                this.dirCopyMap.clear();
                this.completeDirMap.clear();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAttributes() throws Exception {
        if (this.file == null && this.filesets.size() == 0) {
            throw new Exception("Specify at least one source - a file or a fileset.");
        }
        if (this.destFile != null && this.destDir != null) {
            throw new Exception("Only one of tofile and todir may be set.");
        }
        if (this.destFile == null && this.destDir == null) {
            throw new Exception("One of tofile or todir must be set.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new Exception("Use a fileset to copy directories.");
        }
        if (this.destFile != null && this.filesets.size() > 0) {
            if (this.filesets.size() > 1) {
                throw new Exception("Cannot concatenate multiple files into a single file.");
            }
            FileSet fs = this.filesets.elementAt(0);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] srcFiles = ds.getIncludedFiles();
            if (srcFiles.length == 0) {
                throw new Exception("Cannot perform operation from directory to file.");
            }
            if (srcFiles.length != 1) throw new Exception("Cannot concatenate multiple files into a single file.");
            if (this.file != null) throw new Exception("Cannot concatenate multiple files into a single file.");
            this.file = new File(ds.getBasedir(), srcFiles[0]);
            this.filesets.removeElementAt(0);
        }
        if (this.destFile == null) return;
        this.destDir = this.fileUtils.getParentFile(this.destFile);
    }

    protected void scan(File fromDir, File toDir, String[] files, String[] dirs) throws Exception {
        FileNameMapper mapper = null;
        mapper = this.mapperElement != null ? this.mapperElement.getImplementation() : (this.flatten ? new FlatFileNameMapper() : new IdentityMapper());
        this.buildMap(fromDir, toDir, files, mapper, this.fileCopyMap);
        if (this.includeEmpty) {
            this.buildMap(fromDir, toDir, dirs, mapper, this.dirCopyMap);
        }
    }

    protected void buildMap(File fromDir, File toDir, String[] names, FileNameMapper mapper, Hashtable<String, String[]> map) throws Exception {
        int n;
        Object[] toCopy = null;
        if (this.forceOverwrite) {
            Vector<String> v = new Vector<String>();
            String[] stringArray = names;
            int n2 = names.length;
            n = 0;
            while (n < n2) {
                String name = stringArray[n];
                if (mapper.mapFileName(name) != null) {
                    v.addElement(name);
                }
                ++n;
            }
            toCopy = new String[v.size()];
            v.copyInto(toCopy);
        } else {
            SourceFileScanner ds = new SourceFileScanner();
            toCopy = ds.restrict(names, fromDir, toDir, mapper, this.granularity);
        }
        Object[] objectArray = toCopy;
        n = toCopy.length;
        int n3 = 0;
        while (n3 < n) {
            Object elementToCopy = objectArray[n3];
            File src = new File(fromDir, (String)elementToCopy);
            String[] mappedFiles = mapper.mapFileName((String)elementToCopy);
            if (!this.enableMultipleMappings) {
                map.put(src.getAbsolutePath(), new String[]{new File(toDir, mappedFiles[0]).getAbsolutePath()});
            } else {
                int k = 0;
                while (k < mappedFiles.length) {
                    mappedFiles[k] = new File(toDir, mappedFiles[k]).getAbsolutePath();
                    ++k;
                }
                map.put(src.getAbsolutePath(), mappedFiles);
            }
            ++n3;
        }
    }

    protected void doFileOperations() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        Enumeration<Object> e;
        if (this.fileCopyMap.size() > 0) {
            Debug.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            e = this.fileCopyMap.keys();
            while (e.hasMoreElements()) {
                String fromFile = (String)e.nextElement();
                String[] toFiles = this.fileCopyMap.get(fromFile);
                stringArray = toFiles;
                n2 = toFiles.length;
                n = 0;
                while (n < n2) {
                    String toFile = stringArray[n];
                    if (fromFile.equals(toFile)) {
                        Debug.log("Skipping self-copy of " + fromFile);
                    } else {
                        try {
                            Debug.log("Copying " + fromFile + " to " + toFile);
                            this.fileUtils.copyFile(fromFile, toFile, this.forceOverwrite, this.preserveLastModified);
                        }
                        catch (IOException ioe) {
                            String msg = "Failed to copy " + fromFile + " to " + toFile + " due to " + ioe.getMessage();
                            File targetFile = new File(toFile);
                            if (targetFile.exists() && !targetFile.delete()) {
                                msg = String.valueOf(msg) + " and I couldn't delete the corrupt " + toFile;
                            }
                            throw new Exception(msg, ioe);
                        }
                    }
                    ++n;
                }
            }
        }
        if (this.includeEmpty) {
            e = this.dirCopyMap.elements();
            int createCount = 0;
            while (e.hasMoreElements()) {
                String[] dirs;
                stringArray = dirs = e.nextElement();
                n2 = dirs.length;
                n = 0;
                while (n < n2) {
                    String dir = stringArray[n];
                    File d = new File(dir);
                    if (!d.exists()) {
                        if (!d.mkdirs()) {
                            System.err.println("Unable to create directory " + d.getAbsolutePath());
                        } else {
                            ++createCount;
                        }
                    }
                    ++n;
                }
            }
            if (createCount > 0) {
                Debug.log("Copied " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + createCount + " empty director" + (createCount == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }
}

