/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.tools.ant.taskdefs.condition.Os;

public class PathTokenizer {
    private StringTokenizer tokenizer;
    private String lookahead = null;
    private boolean onNetWare = Os.isFamily((String)"netware");
    private boolean dosStyleFilesystem;

    public PathTokenizer(String path) {
        this.tokenizer = this.onNetWare ? new StringTokenizer(path, ":;", true) : new StringTokenizer(path, ":;", false);
        this.dosStyleFilesystem = File.pathSeparatorChar == ';';
    }

    public boolean hasMoreTokens() {
        if (this.lookahead != null) {
            return true;
        }
        return this.tokenizer.hasMoreTokens();
    }

    public String nextToken() throws NoSuchElementException {
        String token = null;
        if (this.lookahead != null) {
            token = this.lookahead;
            this.lookahead = null;
        } else {
            token = this.tokenizer.nextToken().trim();
        }
        if (!this.onNetWare) {
            if (token.length() == 1 && Character.isLetter(token.charAt(0)) && this.dosStyleFilesystem && this.tokenizer.hasMoreTokens()) {
                String nextToken = this.tokenizer.nextToken().trim();
                if (nextToken.startsWith("\\") || nextToken.startsWith("/")) {
                    token = String.valueOf(token) + ":" + nextToken;
                } else {
                    this.lookahead = nextToken;
                }
            }
        } else {
            String nextToken;
            if (token.equals(File.pathSeparator) || token.equals(":")) {
                token = this.tokenizer.nextToken().trim();
            }
            if (this.tokenizer.hasMoreTokens() && !(nextToken = this.tokenizer.nextToken().trim()).equals(File.pathSeparator)) {
                if (nextToken.equals(":")) {
                    if (!(token.startsWith("/") || token.startsWith("\\") || token.startsWith(".") || token.startsWith(".."))) {
                        String oneMore = this.tokenizer.nextToken().trim();
                        if (!oneMore.equals(File.pathSeparator)) {
                            token = String.valueOf(token) + ":" + oneMore;
                        } else {
                            token = String.valueOf(token) + ":";
                            this.lookahead = oneMore;
                        }
                    }
                } else {
                    this.lookahead = nextToken;
                }
            }
        }
        return token;
    }
}

