/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.util.file.FileNameMapper;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.ResourceUtils;
import com.izforge.izpack.util.file.types.Resource;
import com.izforge.izpack.util.file.types.ResourceFactory;
import java.io.File;
import java.util.Vector;

public class SourceFileScanner
implements ResourceFactory {
    private FileUtils fileUtils = FileUtils.getFileUtils();
    private File destDir;

    public String[] restrict(String[] files, File srcDir, File destDir, FileNameMapper mapper) throws Exception {
        return this.restrict(files, srcDir, destDir, mapper, this.fileUtils.getFileTimestampGranularity());
    }

    public String[] restrict(String[] files, File srcDir, File destDir, FileNameMapper mapper, long granularity) throws Exception {
        this.destDir = destDir;
        Vector<Resource> v = new Vector<Resource>();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            File src = this.fileUtils.resolveFile(srcDir, file);
            v.addElement(new Resource(file, src.exists(), src.lastModified(), src.isDirectory()));
            ++n2;
        }
        Object[] sourceresources = new Resource[v.size()];
        v.copyInto(sourceresources);
        Resource[] outofdate = ResourceUtils.selectOutOfDateSources((Resource[])sourceresources, mapper, this, granularity);
        String[] result = new String[outofdate.length];
        int counter = 0;
        while (counter < outofdate.length) {
            result[counter] = outofdate[counter].getName();
            ++counter;
        }
        return result;
    }

    public File[] restrictAsFiles(String[] files, File srcDir, File destDir, FileNameMapper mapper) throws Exception {
        return this.restrictAsFiles(files, srcDir, destDir, mapper, this.fileUtils.getFileTimestampGranularity());
    }

    public File[] restrictAsFiles(String[] files, File srcDir, File destDir, FileNameMapper mapper, long granularity) throws Exception {
        String[] res = this.restrict(files, srcDir, destDir, mapper, granularity);
        File[] result = new File[res.length];
        int i = 0;
        while (i < res.length) {
            result[i] = new File(srcDir, res[i]);
            ++i;
        }
        return result;
    }

    @Override
    public Resource getResource(String name) throws Exception {
        File src = this.fileUtils.resolveFile(this.destDir, name);
        return new Resource(name, src.exists(), src.lastModified(), src.isDirectory());
    }
}

